/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.webdriver.DefaultWebDriverContext;
import com.atlassian.webdriver.DesiredCapabilitiesFactory;
import com.atlassian.webdriver.WebDriverContext;
import com.atlassian.webdriver.browsers.chrome.ChromeBrowser;
import com.atlassian.webdriver.browsers.firefox.FirefoxBrowser;
import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteWebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(RemoteWebDriverFactory.class);
    private static final Pattern remoteBrowserPathPattern = Pattern.compile("^([A-Za-z0-9_.-]+):url=(.*)$");

    public static boolean matches(String browserProperty) {
        return remoteBrowserPathPattern.matcher(browserProperty).matches();
    }

    public static Browser getBrowser(String browserProperty) {
        Matcher matcher = remoteBrowserPathPattern.matcher(browserProperty);
        if (matcher.matches()) {
            return Browser.typeOf((String)matcher.group(1));
        }
        log.warn("Cannot find a url to connect to with a RemoteWebDriver. Falling back to using a local FirefoxDriver instead");
        return Browser.FIREFOX;
    }

    public static WebDriverContext getDriverContext(String browserProperty) {
        Matcher matcher = remoteBrowserPathPattern.matcher(browserProperty);
        if (!matcher.matches()) {
            log.warn("Cannot find a url to connect to with a RemoteWebDriver. Falling back to using a local FirefoxDriver instead");
            return new DefaultWebDriverContext((WebDriver)new FirefoxBrowser().getDriver(), Browser.FIREFOX);
        }
        Browser browserType = Browser.typeOf((String)matcher.group(1));
        String serverUrlString = matcher.group(2);
        URL serverUrl = RemoteWebDriverFactory.buildServerUrl(serverUrlString);
        DesiredCapabilities capabilities = DesiredCapabilitiesFactory.defaultCapabilitiesForBrowser(browserType);
        DesiredCapabilities customCapabilities = DesiredCapabilitiesFactory.customCapabilitiesFromSystemProperty();
        DesiredCapabilities loggingCapabilities = DesiredCapabilitiesFactory.customCapabilitiesForLogging();
        capabilities.merge((Capabilities)RemoteWebDriverFactory.getBrowserSpecificCapabilities(browserType));
        capabilities.merge((Capabilities)customCapabilities);
        capabilities.merge((Capabilities)loggingCapabilities);
        log.debug("Merged capabilities: {}", (Object)capabilities);
        RemoteWebDriver driver = new RemoteWebDriver(serverUrl, (Capabilities)capabilities);
        driver.setFileDetector((FileDetector)new LocalFileDetector());
        return new DefaultWebDriverContext((WebDriver)driver, browserType);
    }

    @VisibleForTesting
    static URL buildServerUrl(String serverUrlString) {
        try {
            StringBuilder sb = new StringBuilder(serverUrlString);
            if (!serverUrlString.contains("wd/hub")) {
                if (!serverUrlString.endsWith("/")) {
                    sb.append("/");
                }
                sb.append("wd/hub");
            }
            return new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            log.error("Invalid url provided: '{}', defaulting to http://localhost:4444/wd/hub", (Object)serverUrlString);
            return RemoteWebDriverFactory.defaultServerUrl();
        }
    }

    @VisibleForTesting
    static URL defaultServerUrl() {
        try {
            return new URL("http://localhost:4444/wd/hub");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @VisibleForTesting
    static MutableCapabilities getBrowserSpecificCapabilities(Browser browser) {
        MutableCapabilities browserSpecificCapabilities = new MutableCapabilities();
        switch (browser) {
            default: {
                log.warn("Unknown browser: {}, cannot get browser specific capabilities.", (Object)browser);
                break;
            }
            case CHROME: {
                browserSpecificCapabilities = new ChromeOptions();
                ChromeBrowser.updateOptions((ChromeOptions)browserSpecificCapabilities);
                break;
            }
            case FIREFOX: {
                browserSpecificCapabilities = new FirefoxOptions();
                FirefoxBrowser.updateOptions((FirefoxOptions)browserSpecificCapabilities);
                FirefoxBrowser.setFirefoxWebdriverLogfile();
            }
        }
        return browserSpecificCapabilities;
    }

    private RemoteWebDriverFactory() {
        throw new AssertionError((Object)"Don't instantiate. It has static methods only.");
    }
}

