/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.webdriver.BrowserstackWebDriverBuilder;
import com.atlassian.webdriver.WebDriverContext;
import com.atlassian.webdriver.WebDriverProperties;
import com.browserstack.local.Local;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserstackWebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(BrowserstackWebDriverFactory.class);
    private static final String[] BS_USER_KEYS = new String[]{"BROWSERSTACK_USER", "BROWSERSTACK_USERNAME"};
    private static final String[] BS_AUTH_KEYS = new String[]{"BROWSERSTACK_ACCESS_KEY", "BROWSERSTACK_ACCESSKEY", "BROWSERSTACK_KEY", "BROWSERSTACK_AUTH"};
    private static final String[] BUILD_KEYS = new String[]{"CI_BUILD_NUMBER", "BAMBOO_BUILD_NUMBER", "BITBUCKET_BUILD_NUMBER"};
    private static final String NAME = "browserstack";
    private final BrowserstackWebDriverBuilder builder;

    public BrowserstackWebDriverFactory() {
        Optional<String> username = BrowserstackWebDriverFactory.findDefinedEnv(BS_USER_KEYS);
        Optional<String> authkey = BrowserstackWebDriverFactory.findDefinedEnv(BS_AUTH_KEYS);
        if (!username.isPresent()) {
            throw new IllegalStateException("Browserstack username must be set in one of the following environment variables: " + Arrays.toString(BS_USER_KEYS));
        }
        if (!authkey.isPresent()) {
            throw new IllegalStateException("Browserstack authentication key must be set in one of the following environment variables: " + Arrays.toString(BS_AUTH_KEYS));
        }
        this.builder = new BrowserstackWebDriverBuilder(username.get(), authkey.get()).withBrowser(System.getProperty("browserstack.browser")).withBrowserVersion(System.getProperty("browserstack.browser.version")).withOS(System.getProperty("browserstack.os")).withOSVersion(System.getProperty("browserstack.os.version")).withProjectName(System.getProperty("browserstack.project")).withTestName(System.getProperty("browserstack.name")).withIdleTimeout(System.getProperty("browserstack.idleTimeout")).withAcceptSslCerts(System.getProperty("acceptSslCerts")).withBuildName(BrowserstackWebDriverFactory.findDefinedEnv(BUILD_KEYS).orElseGet(() -> new Date().toString()));
        this.setFromSystemProperty(this.builder::withScreenResolution, "browserstack.resolution");
        this.setFromSystemProperty(this.builder::withConsoleLogs, "browserstack.console");
        this.setFromSystemProperty(this.builder::withVisualLogs, "browserstack.debug");
        this.setFromSystemProperty(this.builder::withNetworkLogs, "browserstack.networkLogs");
        this.setFromSystemProperty(this.builder::withVideoLogs, "browserstack.video");
        String capabilitiesString = WebDriverProperties.WEBDRIVER_CAPABILITIES.getSystemProperty();
        log.info("Loading custom capabilities: " + capabilitiesString);
        this.setFromMap(this.builder::withCapability, this.splitPropertyString(capabilitiesString));
    }

    public WebDriverContext getDriverContext(Local local) throws Exception {
        return this.builder.withLocalConnection(local).withLocalIdentifier("atl-selenium_" + new Date().toInstant().toString()).build();
    }

    public static boolean matches(String browserProperty) {
        return NAME.equalsIgnoreCase(browserProperty);
    }

    private static Optional<String> findDefinedEnv(String ... keys) {
        for (String key : keys) {
            String val = System.getenv(key);
            if (!StringUtils.isNotBlank((CharSequence)val)) continue;
            return Optional.of(val);
        }
        log.debug("None of the environment variables has been found: " + Arrays.toString(keys));
        return Optional.empty();
    }

    private void setFromSystemProperty(Consumer<String> callback, String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            log.debug("Passing system property: " + propertyName);
            callback.accept(value);
        }
    }

    private void setFromMap(BiConsumer<String, String> callback, Map<String, String> properties) {
        properties.forEach(callback);
    }

    private Map<String, String> splitPropertyString(String capabilitiesString) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)capabilitiesString)) {
            Arrays.stream(capabilitiesString.split(";")).map(cap -> cap.split("=")).filter(nameVal -> ((String[])nameVal).length > 0).forEach(nameVal -> {
                String cfr_ignored_0 = properties.put(nameVal[0], ((String[])nameVal).length > 1 ? nameVal[1] : null);
            });
        }
        return properties;
    }
}

