/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.testing.annotation.WindowSize;
import com.atlassian.webdriver.testing.rule.WebDriverSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowSizeRule
extends TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(WindowSizeRule.class);
    private final WebDriverSupport<? extends WebDriver> support;

    @Inject
    public WindowSizeRule(WebDriver webDriver) {
        this.support = WebDriverSupport.forInstance(webDriver);
    }

    public WindowSizeRule(Supplier<? extends WebDriver> driverSupplier) {
        this.support = WebDriverSupport.forSupplier(driverSupplier);
    }

    public WindowSizeRule() {
        this.support = WebDriverSupport.fromAutoInstall();
    }

    protected void starting(Description description) {
        try {
            WindowSize windowSize = this.findAnnotation(description);
            if (windowSize != null) {
                this.handleWindowSize(windowSize);
            } else {
                this.maximizeWindow();
            }
        }
        catch (WebDriverException e) {
            log.warn("Caught exception while trying to adjust window size.");
            log.debug("Exception while trying to adjust window size", (Throwable)e);
        }
    }

    private WindowSize findAnnotation(Description description) {
        if (description.getAnnotation(WindowSize.class) != null) {
            return (WindowSize)description.getAnnotation(WindowSize.class);
        }
        if (description.getTestClass() != null && description.getTestClass().isAnnotationPresent(WindowSize.class)) {
            return description.getTestClass().getAnnotation(WindowSize.class);
        }
        return null;
    }

    private void handleWindowSize(WindowSize windowSize) {
        if (windowSize.maximize()) {
            this.maximizeWindow();
        } else {
            this.setSize(this.computeDimension(windowSize));
        }
    }

    private void maximizeWindow() {
        this.support.getDriver().manage().window().maximize();
    }

    private void setSize(Dimension dimension) {
        this.support.getDriver().manage().window().setPosition(new Point(0, 0));
        this.support.getDriver().manage().window().setSize(dimension);
        this.support.getDriver().manage().window().setSize(dimension);
    }

    private Dimension computeDimension(WindowSize windowSize) {
        Preconditions.checkState((windowSize.width() > 0 ? 1 : 0) != 0, (Object)("@WindowSize width must be greater than 0, was: " + windowSize.width()));
        Preconditions.checkState((windowSize.height() > 0 ? 1 : 0) != 0, (Object)("@WindowSize height must be greater than 0, was: " + windowSize.height()));
        return new Dimension(windowSize.width(), windowSize.height());
    }
}

