/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.debug.WebDriverDebug;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class VisualRegressionRule
extends TestWatcher {
    private final long PAGE_LOAD_TIMEOUT_SEC = 5L;
    private Class testSuiteClass;
    private WebDriver webDriver;
    private WebDriverDebug webDriverDebug;
    private String imageDir;
    private String filenamePrefix;
    private int counter = 0;

    public VisualRegressionRule(Class testSuiteClass, WebDriver webDriver) {
        this(testSuiteClass, webDriver, "target/vr-images");
    }

    public VisualRegressionRule(Class testSuiteClass, WebDriver webDriver, String imageDir) {
        this.testSuiteClass = testSuiteClass;
        this.imageDir = imageDir;
        this.webDriver = webDriver;
        this.webDriverDebug = new WebDriverDebug(webDriver);
    }

    protected void starting(@Nonnull Description d) {
        String sanitizedPackageClassName = this.testSuiteClass.getCanonicalName().replace(".", "/");
        this.filenamePrefix = String.format("%s/%s", sanitizedPackageClassName, d.getMethodName());
    }

    protected void failed(@Nonnull Throwable e, @Nonnull Description d) {
        this.captureId("failed-test");
    }

    public void capture() {
        this.captureId(Integer.toString(this.counter++));
    }

    public void captureAfterMs() {
        this.captureAfterMs(1000);
    }

    public void captureAfterMs(int milliseconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.capture();
    }

    public void captureId(String id) {
        new WebDriverWait(this.webDriver, 5L).until(webDriver -> ((JavascriptExecutor)webDriver).executeScript("return document.readyState", new Object[0]).equals("complete"));
        String filename = String.format("%s-%s.png", this.filenamePrefix, id);
        this.webDriverDebug.takeScreenshotTo(new File(this.imageDir, filename));
    }

    public void captureIdAfterMs(String id) {
        this.captureIdAfterMs(id, 1000);
    }

    public void captureIdAfterMs(String id, int milliseconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.captureId(id);
    }
}

