/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.edge;

import com.atlassian.browsers.BrowserConfig;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EdgeBrowser {
    private static final Logger log = LoggerFactory.getLogger(EdgeBrowser.class);
    public static final String EDGE_SERVICE_EXECUTABLE = "msedgedriver" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");

    private EdgeBrowser() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static EdgeDriver createEdgeDriver(@Nullable String browserPath, @Nullable BrowserConfig config) {
        if (EdgeBrowser.noBrowserPath(browserPath) && EdgeBrowser.noServicePath(config)) {
            return EdgeBrowser.createDefaultDriver();
        }
        EdgeDriverService service = (EdgeDriverService)((EdgeDriverService.Builder)EdgeBrowser.setBrowserExecutablePath(browserPath, EdgeBrowser.setServiceExecutablePath(config, new EdgeDriverService.Builder())).usingAnyFreePort()).build();
        return new EdgeDriver(service);
    }

    public static EdgeDriver createDefaultDriver() {
        return new EdgeDriver();
    }

    private static boolean noBrowserPath(@Nullable String browserPath) {
        return browserPath == null;
    }

    private static boolean hasServicePath(@Nullable BrowserConfig config) {
        return config != null && config.getProfilePath() != null;
    }

    private static boolean noServicePath(@Nullable BrowserConfig config) {
        return !EdgeBrowser.hasServicePath(config);
    }

    private static EdgeDriverService.Builder setServiceExecutablePath(BrowserConfig browserConfig, EdgeDriverService.Builder builder) {
        File profilePath;
        File edgeDriverFile;
        if (EdgeBrowser.hasServicePath(browserConfig) && (edgeDriverFile = new File(profilePath = new File(browserConfig.getProfilePath()), EDGE_SERVICE_EXECUTABLE)).isFile()) {
            builder.usingDriverExecutable(edgeDriverFile);
        }
        return builder;
    }

    private static EdgeDriverService.Builder setBrowserExecutablePath(String browserPath, EdgeDriverService.Builder builder) {
        if (browserPath != null) {
            log.warn("Non-null browser path configured for IE: '{}', but IEDriver does not support custom browser paths", (Object)browserPath);
        }
        return builder;
    }
}

