/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.SeleniumClient;
import com.thoughtworks.selenium.SeleniumException;
import java.util.LinkedList;

public class XpathHelper {
    public static void clickButtonWithClass(String className, SeleniumClient client) {
        XpathHelper.clickElementWithClass("button", className, client);
    }

    public static void clickElementWithClass(String elementName, String className, SeleniumClient client) {
        client.click("//" + XpathHelper.elementWithClass(elementName, className));
    }

    public static String elementWithClass(String className) {
        return XpathHelper.elementWithClass("*", className);
    }

    public static String elementWithClass(String elementName, String className) {
        return elementName + "[contains(@class, '" + className + "')]";
    }

    public static String[] getAllMatchingAttributes(String query, String attribute, SeleniumClient client) {
        LinkedList<String> matches = new LinkedList<String>();
        try {
            int i = 1;
            String attr = XpathHelper.getAttribute(client, query, attribute, i++);
            while (attr != null) {
                matches.add(attr);
                attr = XpathHelper.getAttribute(client, query, attribute, i++);
            }
        }
        catch (SeleniumException se) {
            // empty catch block
        }
        return matches.toArray(new String[matches.size()]);
    }

    private static String getAttribute(SeleniumClient client, String query, String attribute, int i) {
        return client.getAttribute(query + "[" + i + "]/@" + attribute);
    }
}

