/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.SeleniumAssertions;
import com.atlassian.selenium.SeleniumClient;
import com.atlassian.selenium.SeleniumConfiguration;
import com.atlassian.selenium.SeleniumStarter;
import junit.framework.TestCase;

public abstract class SeleniumTest
extends TestCase {
    protected SeleniumAssertions assertThat;
    protected SeleniumClient client;
    protected SeleniumConfiguration config;

    public abstract SeleniumConfiguration getSeleniumConfiguration();

    public final void setUp() throws Exception {
        super.setUp();
        this.config = this.getSeleniumConfiguration();
        if (SeleniumStarter.getInstance().isManual()) {
            SeleniumStarter.getInstance().start(this.config);
        }
        this.client = this.getSeleniumClient();
        this.assertThat = new SeleniumAssertions(this.client, this.config);
        this.onSetUp();
    }

    protected SeleniumClient getSeleniumClient() {
        return SeleniumStarter.getInstance().getSeleniumClient(this.getSeleniumConfiguration());
    }

    protected void onSetUp() throws Exception {
    }

    public final void tearDown() throws Exception {
        super.tearDown();
        this.onTearDown();
        if (SeleniumStarter.getInstance().isManual()) {
            SeleniumStarter.getInstance().stop();
        }
    }

    protected void onTearDown() throws Exception {
    }
}

