/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.webdriver;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.webdriver.GenericWebDriverTimedQuery;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@Internal
public class WebDriverLocatableBasedTimedQuery<T>
extends GenericWebDriverTimedQuery<T> {
    private final WebDriverLocatable locatable;

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, WebDriver driver, Function<WebElement, T> valueProvider, long timeout) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider), timeout);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, WebDriver driver, Function<WebElement, T> valueProvider, long timeout, long interval) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider), timeout, interval);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatable locatable, WebDriver driver, Function<WebElement, T> valueProvider, long timeout, long interval, T invalidValue) {
        super(new LocatableBasedSupplier<T>(driver, locatable, valueProvider, invalidValue), timeout, interval);
        this.locatable = locatable;
    }

    public WebDriverLocatableBasedTimedQuery(WebDriverLocatableBasedTimedQuery<T> origin, long timeout) {
        super(origin.webElementSupplier(), timeout, origin.interval);
        this.locatable = origin.locatable;
    }

    LocatableBasedSupplier<T> webElementSupplier() {
        return (LocatableBasedSupplier)this.valueSupplier;
    }

    Function<WebElement, T> valueProvider() {
        return ((LocatableBasedSupplier)this.webElementSupplier()).valueProvider;
    }

    @Override
    @Nonnull
    public String toString() {
        return StringConcat.asString(super.toString(), "[locatable=", this.locatable, ",valueProvider=", this.valueProvider(), "]");
    }

    private static class LocatableBasedSupplier<S>
    implements Supplier<S> {
        private final WebDriver webDriver;
        private final WebDriverLocatable locatable;
        private final Function<WebElement, S> valueProvider;
        private final S invalidValue;

        public LocatableBasedSupplier(WebDriver webDriver, WebDriverLocatable locatable, Function<WebElement, S> valueProvider, S invalid) {
            this.valueProvider = valueProvider;
            this.webDriver = webDriver;
            this.locatable = Objects.requireNonNull(locatable, "WebDriverLocatable can't be null");
            this.invalidValue = invalid;
        }

        public LocatableBasedSupplier(WebDriver webDriver, WebDriverLocatable locatable, Function<WebElement, S> valueProvider) {
            this(webDriver, locatable, valueProvider, null);
        }

        public S get() {
            try {
                return (S)this.valueProvider.apply((Object)((WebElement)this.locatable.waitUntilLocated(this.webDriver, WebDriverLocatable.LocateTimeout.zero())));
            }
            catch (StaleElementReferenceException e) {
                throw new GenericWebDriverTimedQuery.InvalidValue(this.invalidValue);
            }
            catch (NoSuchElementException e1) {
                throw new GenericWebDriverTimedQuery.InvalidValue(this.invalidValue);
            }
        }
    }
}

