package com.atlassian.sal.core.net;

import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ProxyRoutePlanner extends DefaultRoutePlanner {
    private final HttpHost proxy;
    private final String[] nonProxyHosts;

    public ProxyRoutePlanner(final ProxyConfig proxyConfig) {
        super(null);
        this.proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
        this.nonProxyHosts = proxyConfig.getNonProxyHosts();
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpContext context) {
        return ProxyUtil.shouldBeProxied(target.getHostName(), nonProxyHosts) ? proxy : null;
    }
}
