/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.pluginsettings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.core.pluginsettings.PluginSettingStringSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStringPluginSettings
implements PluginSettings {
    private static final Logger log = LoggerFactory.getLogger(AbstractStringPluginSettings.class);
    private final KeyValueStore store;
    private final int maxSerializedValueLength;
    private final PluginSettingStringSerializer.StringSerializationMode stringSerializationMode;

    @Deprecated
    public AbstractStringPluginSettings() {
        this.store = new KeyValueStore(){

            @Override
            public void put(String key, String value) {
                AbstractStringPluginSettings.this.putActual(key, value);
            }

            @Override
            public String get(String key) {
                return AbstractStringPluginSettings.this.getActual(key);
            }

            @Override
            public void remove(String key) {
                AbstractStringPluginSettings.this.removeActual(key);
            }
        };
        this.stringSerializationMode = PluginSettingStringSerializer.StringSerializationMode.LEGACY;
        this.maxSerializedValueLength = -1;
    }

    public AbstractStringPluginSettings(KeyValueStore store, int maxSerializedValueLength, PluginSettingStringSerializer.StringSerializationMode stringSerializationMode) {
        this.store = Objects.requireNonNull(store);
        this.maxSerializedValueLength = maxSerializedValueLength;
        this.stringSerializationMode = Objects.requireNonNull(stringSerializationMode);
    }

    public Object get(String key) {
        AbstractStringPluginSettings.validateKey(key);
        return PluginSettingStringSerializer.deserialize(this.store.get(key), this.stringSerializationMode);
    }

    public Object put(String key, Object value) {
        AbstractStringPluginSettings.validateKey(key);
        AbstractStringPluginSettings.validateValue(value);
        if (value == null || "".equals(value)) {
            return this.remove(key);
        }
        String serialized = PluginSettingStringSerializer.serialize(value, this.stringSerializationMode);
        if (this.maxSerializedValueLength > 0) {
            Validate.inclusiveBetween((long)1L, (long)this.maxSerializedValueLength, (long)serialized.length(), (String)"Serialized value cannot be longer than %,d characters".formatted(this.maxSerializedValueLength));
        }
        Object got = null;
        try {
            got = this.get(key);
        }
        catch (CorruptPluginSettingValueException e) {
            log.warn("Existing value was corrupt, force-overwriting", (Throwable)e);
        }
        this.store.put(key, serialized);
        return got;
    }

    public Object remove(String key) {
        AbstractStringPluginSettings.validateKey(key);
        Object oldValue = null;
        try {
            oldValue = this.get(key);
            if (oldValue != null) {
                this.store.remove(key);
            }
        }
        catch (CorruptPluginSettingValueException e) {
            log.warn("Existing value was corrupt, force-removing", (Throwable)e);
            this.store.remove(key);
        }
        return oldValue;
    }

    public static void validateKey(String key) {
        Validate.isTrue((key != null ? 1 : 0) != 0, (String)"Key cannot be null", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)255L, (long)key.length(), (String)"Key cannot be longer than %s characters".formatted(255));
    }

    public static void validateValue(Object val) {
        if (!(val == null || val instanceof List || val instanceof Set || val instanceof Map || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Boolean)) {
            throw new UnsupportedPluginSettingValueTypeException("Property type: '%s' not supported".formatted(val.getClass().getName()));
        }
        if (val instanceof Collection) {
            Collection coll = (Collection)val;
            for (Object e : coll) {
                if (e instanceof String) continue;
                throw new UnsupportedPluginSettingValueTypeException("Collection containing non-String or null object not supported: %s".formatted(e));
            }
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new UnsupportedPluginSettingValueTypeException("Map containing non-String or null key not supported: %s".formatted(entry.getKey()));
                }
                if (entry.getValue() instanceof String) continue;
                throw new UnsupportedPluginSettingValueTypeException("Map containing non-String or null value not supported: %s".formatted(entry.getValue()));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStringPluginSettings that = (AbstractStringPluginSettings)o;
        return Objects.equals(this.store, that.store) && Objects.equals((Object)this.stringSerializationMode, (Object)that.stringSerializationMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.store, this.stringSerializationMode});
    }

    @Deprecated
    protected void putActual(String key, String val) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected String getActual(String key) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void removeActual(String key) {
        throw new UnsupportedOperationException();
    }

    public static interface KeyValueStore {
        public void put(String var1, String var2);

        public String get(String var1);

        public void remove(String var1);
    }

    public static class CorruptPluginSettingValueException
    extends IllegalStateException {
        CorruptPluginSettingValueException(String s) {
            super(s);
        }

        CorruptPluginSettingValueException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UnsupportedPluginSettingValueTypeException
    extends IllegalArgumentException {
        UnsupportedPluginSettingValueTypeException(String s) {
            super(s);
        }

        UnsupportedPluginSettingValueTypeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

