/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.HttpClientRequestFactory;
import com.atlassian.sal.core.net.IllegalURLException;
import com.atlassian.sal.core.net.ProxyConfig;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhitelistAwareHttpClientRequestFactory
extends HttpClientRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(WhitelistAwareHttpClientRequestFactory.class);
    private final OutboundWhitelist outboundWhitelist;

    public WhitelistAwareHttpClientRequestFactory(OutboundWhitelist outboundWhitelist) {
        this.outboundWhitelist = Objects.requireNonNull(outboundWhitelist);
    }

    public WhitelistAwareHttpClientRequestFactory(ProxyConfig proxyConfig, OutboundWhitelist outboundWhitelist) {
        super(proxyConfig);
        this.outboundWhitelist = Objects.requireNonNull(outboundWhitelist);
    }

    @Override
    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        log.debug("Creating HttpClientRequest with proxy config:", this.proxyConfigSupplier.get());
        this.validateUrlAgainstWhitelist(url);
        return super.createRequest(methodType, url);
    }

    private void validateUrlAgainstWhitelist(String url) {
        if (!this.outboundWhitelist.isAllowed(URI.create(url))) {
            String exceptionMessage = String.format("The provided url- %s is not included in the whitelist!.Please add the url to whitelist to allow access", url);
            throw new IllegalURLException(exceptionMessage);
        }
    }
}

