/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.plugin.util.PluginKeyStack;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ResponseProtocolException;
import com.atlassian.sal.api.net.ResponseStatusException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.core.net.HttpClientResponse;
import com.atlassian.sal.core.net.SystemPropertiesConnectionConfig;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequest<T extends Request<?, ?>, RESP extends Response>
implements Request<HttpClientRequest<?, ?>, HttpClientResponse> {
    @VisibleForTesting
    static final String METRIC_NAME = "http.sal.request";
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequest.class);
    private final CloseableHttpClient httpClient;
    private final List<NameValuePair> requestParameters;
    protected final HttpClientContext httpClientContext;
    final ClassicRequestBuilder requestBuilder;
    final RequestConfig.Builder requestConfigBuilder;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final String pluginKey;

    public HttpClientRequest(CloseableHttpClient httpClient, HttpClientContext httpClientContext, Request.MethodType initialMethodType, String initialUrl) {
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
        this.requestBuilder = ClassicRequestBuilder.create((String)initialMethodType.toString()).setUri(initialUrl);
        this.requestParameters = new LinkedList<NameValuePair>();
        this.pluginKey = PluginKeyStack.getFirstPluginKey();
        SystemPropertiesConnectionConfig connectionConfig = new SystemPropertiesConnectionConfig();
        this.requestConfigBuilder = RequestConfig.custom().setConnectTimeout((long)connectionConfig.getConnectionTimeout(), TimeUnit.MILLISECONDS).setResponseTimeout((long)connectionConfig.getSocketTimeout(), TimeUnit.MILLISECONDS).setMaxRedirects(connectionConfig.getMaxRedirects()).setCookieSpec("relaxed");
    }

    public String execute() throws ResponseException {
        return (String)this.executeAndReturn(response -> {
            if (!response.isSuccessful()) {
                throw new ResponseStatusException("Unexpected response received. Status code: " + response.getStatusCode(), response);
            }
            return response.getResponseBodyAsString();
        });
    }

    public void execute(ResponseHandler<? super HttpClientResponse> responseHandler) throws ResponseException {
        this.executeAndReturn(response -> {
            responseHandler.handle(response);
            return null;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <RET> RET executeAndReturn(ReturningResponseHandler<? super HttpClientResponse, RET> responseHandler) throws ResponseException {
        if (!this.requestParameters.isEmpty()) {
            this.requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity(this.requestParameters, StandardCharsets.UTF_8));
        }
        this.httpClientContext.setRequestConfig(this.requestConfigBuilder.build());
        ClassicHttpRequest request = this.requestBuilder.build();
        log.debug("Executing request:{}", (Object)request);
        try (CloseableHttpResponse response = this.httpClient.execute(request, (HttpContext)this.httpClientContext);){
            Object object;
            block16: {
                Ticker ignored = Metrics.metric((String)METRIC_NAME).tag("pluginKeyAtCreation", this.pluginKey).tag("action", request.getMethod()).optionalTag("url", request.getRequestUri()).withAnalytics().startTimer();
                try {
                    object = responseHandler.handle((Response)new HttpClientResponse(response));
                    if (ignored == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return (RET)object;
        }
        catch (ClientProtocolException cpe) {
            throw new ResponseProtocolException((Throwable)cpe);
        }
        catch (IOException e) {
            throw new ResponseException((Throwable)e);
        }
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public HttpClientRequest addBasicAuthentication(String hostname, String username, String password) {
        BasicScheme authScheme = new BasicScheme();
        authScheme.initPreemptive((Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
        this.httpClientContext.getAuthCache().put(new HttpHost(hostname), (AuthScheme)authScheme);
        return this;
    }

    public HttpClientRequest setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectionRequestTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public HttpClientRequest setSoTimeout(int soTimeout) {
        this.requestConfigBuilder.setResponseTimeout((long)soTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public HttpClientRequest setUrl(String url) {
        this.requestBuilder.setUri(url);
        return this;
    }

    public HttpClientRequest setRequestBody(String requestBody) {
        return this.setRequestBody(requestBody, ContentType.TEXT_PLAIN.getMimeType());
    }

    public HttpClientRequest setRequestBody(String requestBodyString, String contentTypeString) {
        Objects.requireNonNull(requestBodyString);
        Objects.requireNonNull(contentTypeString);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        this.requestBuilder.setEntity((HttpEntity)new StringEntity(requestBodyString, ContentType.create((String)contentTypeString, (Charset)StandardCharsets.UTF_8)));
        return this;
    }

    public HttpClientRequest setFiles(List<RequestFilePart> requestBodyFiles) {
        Objects.requireNonNull(requestBodyFiles);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (RequestFilePart requestBodyFile : requestBodyFiles) {
            ContentType fileContentType = ContentType.create((String)requestBodyFile.getContentType());
            multipartEntityBuilder.addBinaryBody(requestBodyFile.getParameterName(), requestBodyFile.getFile(), fileContentType, requestBodyFile.getFileName());
        }
        this.requestBuilder.setEntity(multipartEntityBuilder.build());
        return this;
    }

    public HttpClientRequest addRequestParameters(String ... params) {
        Objects.requireNonNull(params);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("You must enter an even number of arguments.");
        }
        for (int i = 0; i < params.length; i += 2) {
            String name = params[i];
            String value = params[i + 1];
            this.requestParameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return this;
    }

    private boolean isRequestBodyMethod() {
        String methodType = this.requestBuilder.getMethod();
        return "POST".equals(methodType) || "PUT".equals(methodType) || "GET".equals(methodType);
    }

    public HttpClientRequest addHeader(String headerName, String headerValue) {
        this.headers.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
        this.requestBuilder.addHeader(headerName, headerValue);
        return this;
    }

    public HttpClientRequest setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, new ArrayList<String>(Collections.singletonList(headerValue)));
        this.requestBuilder.setHeader(headerName, headerValue);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean follow) {
        this.requestConfigBuilder.setRedirectsEnabled(follow);
        return this;
    }

    public HttpClientRequest setEntity(Object entity) {
        throw new UnsupportedOperationException("This SAL request does not support object marshalling. Use the RequestFactory component instead.");
    }
}

