/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.util.Objects;

class ThreadLocalDelegateRunnable<C>
implements Runnable {
    private final C context;
    private final Runnable delegate;
    private final ThreadLocalContextManager<C> manager;
    private final ClassLoader contextClassLoader;

    ThreadLocalDelegateRunnable(ThreadLocalContextManager<C> manager, Runnable delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.manager = Objects.requireNonNull(manager);
        this.context = manager.getThreadLocalContext();
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void run() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            this.manager.setThreadLocalContext(this.context);
            this.delegate.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            this.manager.clearThreadLocalContext();
        }
    }
}

