/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.permission;

import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.NotAuthenticatedException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

public class DefaultPermissionEnforcer
implements PermissionEnforcer {
    private final UserManager userManager;

    public DefaultPermissionEnforcer(UserManager userManager) {
        this.userManager = userManager;
    }

    public void enforceAdmin() {
        if (!this.userManager.isAdmin(this.getRemoteUserOrThrow())) {
            throw new AuthorisationException("You must be an administrator to access this resource");
        }
    }

    public void enforceAuthenticated() {
        this.getRemoteUserOrThrow();
    }

    public void enforceSystemAdmin() {
        if (!this.userManager.isSystemAdmin(this.getRemoteUserOrThrow())) {
            throw new AuthorisationException("You must be an administrator to access this resource");
        }
    }

    public boolean isAdmin() {
        UserKey key = this.userManager.getRemoteUserKey();
        return key != null && this.userManager.isAdmin(key);
    }

    public boolean isAuthenticated() {
        return this.userManager.getRemoteUserKey() != null;
    }

    public boolean isSystemAdmin() {
        UserKey key = this.userManager.getRemoteUserKey();
        return key != null && this.userManager.isSystemAdmin(key);
    }

    private UserKey getRemoteUserOrThrow() {
        UserKey key = this.userManager.getRemoteUserKey();
        if (key == null) {
            throw new NotAuthenticatedException();
        }
        return key;
    }
}

