/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.message.DefaultMessage;
import com.atlassian.sal.core.upgrade.PluginUpgrader;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultPluginUpgradeManager
implements PluginUpgradeManager,
LifecycleAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginUpgradeManager.class);
    protected static final String LOCK_TIMEOUT_PROPERTY = "sal.upgrade.task.lock.timeout";
    protected static final int LOCK_TIMEOUT_SECONDS = Integer.getInteger("sal.upgrade.task.lock.timeout", 300000);
    private volatile boolean started = false;
    private final List<PluginUpgradeTask> upgradeTasks;
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginEventManager pluginEventManager;
    private final ClusterLockService clusterLockService;

    public DefaultPluginUpgradeManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory, PluginEventManager pluginEventManager, ClusterLockService clusterLockService) {
        this.upgradeTasks = upgradeTasks;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginEventManager = pluginEventManager;
        this.clusterLockService = clusterLockService;
    }

    @Deprecated
    public void onBind(PluginUpgradeTask task, Map props) {
        log.debug("onbind task = [" + task.getPluginKey() + ", " + task.getBuildNumber() + "] ");
    }

    public void onStart() {
        log.debug("onStart");
        List<Message> messages = this.upgrade();
        if (messages != null) {
            for (Message msg : messages) {
                log.error("Upgrade error: " + msg);
            }
        }
        this.started = true;
    }

    public void onStop() {
        this.pluginEventManager.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        List<Message> messages;
        if (this.started && (messages = this.upgradeInternal(event.getPlugin())) != null && messages.size() > 0) {
            log.error("Error(s) encountered while upgrading plugin '" + event.getPlugin().getName() + "' on enable.");
            for (Message msg : messages) {
                log.error("Upgrade error: " + msg);
            }
        }
    }

    protected Map<String, List<PluginUpgradeTask>> getUpgradeTasks() {
        HashMap<String, List<PluginUpgradeTask>> pluginUpgrades = new HashMap<String, List<PluginUpgradeTask>>();
        for (PluginUpgradeTask upgradeTask : this.upgradeTasks) {
            ArrayList<PluginUpgradeTask> upgrades = (ArrayList<PluginUpgradeTask>)pluginUpgrades.get(upgradeTask.getPluginKey());
            if (upgrades == null) {
                upgrades = new ArrayList<PluginUpgradeTask>();
                pluginUpgrades.put(upgradeTask.getPluginKey(), upgrades);
            }
            upgrades.add(upgradeTask);
        }
        return pluginUpgrades;
    }

    public List<Message> upgrade() {
        return this.upgradeInternal();
    }

    public List<Message> upgradeInternal() {
        log.info("Running plugin upgrade tasks...");
        Map<String, List<PluginUpgradeTask>> pluginUpgrades = this.getUpgradeTasks();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String pluginKey : pluginUpgrades.keySet()) {
            List<PluginUpgradeTask> upgrades;
            List<Message> upgradeMessages = this.upgradePlugin(pluginKey, upgrades = pluginUpgrades.get(pluginKey));
            if (upgradeMessages == null) continue;
            messages.addAll(upgradeMessages);
        }
        return messages;
    }

    public List<Message> upgradeInternal(Plugin plugin) {
        String pluginKey;
        Map<String, List<PluginUpgradeTask>> pluginUpgrades = this.getUpgradeTasks();
        List<PluginUpgradeTask> upgrades = pluginUpgrades.get(pluginKey = plugin.getKey());
        if (upgrades == null) {
            return null;
        }
        return this.upgradePlugin(pluginKey, upgrades);
    }

    private List<Message> upgradePlugin(final String pluginKey, final List<PluginUpgradeTask> upgrades) {
        return (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Message> doInTransaction() {
                Plugin plugin = DefaultPluginUpgradeManager.this.pluginAccessor.getPlugin(pluginKey);
                if (plugin == null) {
                    throw new IllegalArgumentException("Invalid plugin key: " + pluginKey);
                }
                PluginUpgrader pluginUpgrader = new PluginUpgrader(plugin, DefaultPluginUpgradeManager.this.pluginSettingsFactory.createGlobalSettings(), upgrades);
                String lockName = "sal.upgrade." + pluginKey;
                ClusterLock lock = DefaultPluginUpgradeManager.this.clusterLockService.getLockForName(lockName);
                try {
                    if (!lock.tryLock((long)LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
                        String timeoutMessage = "unable to acquire cluster lock named '" + lockName + "' after waiting " + LOCK_TIMEOUT_SECONDS + " seconds; note that this timeout may be adjusted via the system property '" + DefaultPluginUpgradeManager.LOCK_TIMEOUT_PROPERTY + "'";
                        log.error(timeoutMessage);
                        return ImmutableList.of((Object)new DefaultMessage(timeoutMessage, new Serializable[0]));
                    }
                }
                catch (InterruptedException e) {
                    String interruptedMessage = "interrupted while trying to acquire cluster lock named '" + lockName + "' " + e.getMessage();
                    log.error(interruptedMessage);
                    return ImmutableList.of((Object)new DefaultMessage(interruptedMessage, new Serializable[0]));
                }
                try {
                    List<Message> list = pluginUpgrader.upgrade();
                    return list;
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }
}

