/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.rdbms;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.RdbmsException;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.core.rdbms.WrappedConnection;
import com.atlassian.sal.spi.HostConnectionAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class DefaultTransactionalExecutor
implements TransactionalExecutor {
    private final HostConnectionAccessor hostConnectionAccessor;
    @VisibleForTesting
    boolean readOnly;
    @VisibleForTesting
    boolean newTransaction;

    public DefaultTransactionalExecutor(@Nonnull HostConnectionAccessor hostConnectionAccessor, boolean readOnly, boolean newTransaction) {
        this.hostConnectionAccessor = hostConnectionAccessor;
        this.readOnly = readOnly;
        this.newTransaction = newTransaction;
    }

    public <A> A execute(@Nonnull ConnectionCallback<A> callback) {
        return (A)this.hostConnectionAccessor.execute(this.readOnly, this.newTransaction, connection -> this.executeInternal(connection, callback));
    }

    @Nonnull
    public Option<String> getSchemaName() {
        return this.hostConnectionAccessor.getSchemaName();
    }

    @Nonnull
    public TransactionalExecutor readOnly() {
        this.readOnly = true;
        return this;
    }

    @Nonnull
    public TransactionalExecutor readWrite() {
        this.readOnly = false;
        return this;
    }

    @Nonnull
    public TransactionalExecutor newTransaction() {
        this.newTransaction = true;
        return this;
    }

    @Nonnull
    public TransactionalExecutor existingTransaction() {
        this.newTransaction = false;
        return this;
    }

    @VisibleForTesting
    <A> A executeInternal(@Nonnull Connection connection, @Nonnull ConnectionCallback<A> callback) {
        this.assertAutoCommitFalse(connection);
        try (WrappedConnection wrappedConnection = new WrappedConnection(connection);){
            Object object = callback.execute((Connection)wrappedConnection);
            return (A)object;
        }
    }

    private void assertAutoCommitFalse(Connection connection) {
        try {
            if (connection.getAutoCommit()) {
                throw new IllegalStateException("com.atlassian.sal.spi.HostConnectionAccessor returned connection with autocommit set");
            }
        }
        catch (SQLException e) {
            throw new RdbmsException("unable to invoke java.sql.Connection#getAutoCommit", (Throwable)e);
        }
    }
}

