/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ResponseProtocolException;
import com.atlassian.sal.api.net.ResponseStatusException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.core.net.HttpClientResponse;
import com.atlassian.sal.core.net.SystemPropertiesConnectionConfig;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequest<T extends Request<?, ?>, RESP extends Response>
implements Request<HttpClientRequest<?, ?>, HttpClientResponse> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequest.class);
    private final CloseableHttpClient httpClient;
    protected final HttpClientContext httpClientContext;
    final RequestBuilder requestBuilder;
    final RequestConfig.Builder requestConfigBuilder;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public HttpClientRequest(CloseableHttpClient httpClient, HttpClientContext httpClientContext, Request.MethodType initialMethodType, String initialUrl) {
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
        this.requestBuilder = RequestBuilder.create((String)initialMethodType.toString()).setUri(initialUrl);
        SystemPropertiesConnectionConfig connectionConfig = new SystemPropertiesConnectionConfig();
        this.requestConfigBuilder = RequestConfig.custom().setConnectTimeout(connectionConfig.getConnectionTimeout()).setSocketTimeout(connectionConfig.getSocketTimeout()).setMaxRedirects(connectionConfig.getMaxRedirects());
    }

    public String execute() throws ResponseException {
        return this.executeAndReturn(new ReturningResponseHandler<HttpClientResponse, String>(){

            public String handle(HttpClientResponse response) throws ResponseException {
                if (!response.isSuccessful()) {
                    throw new ResponseStatusException("Unexpected response received. Status code: " + response.getStatusCode(), (Response)response);
                }
                return response.getResponseBodyAsString();
            }
        });
    }

    public void execute(final ResponseHandler<? super HttpClientResponse> responseHandler) throws ResponseException {
        this.executeAndReturn(new ReturningResponseHandler<HttpClientResponse, Void>(){

            public Void handle(HttpClientResponse response) throws ResponseException {
                responseHandler.handle((Response)response);
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <RET> RET executeAndReturn(ReturningResponseHandler<? super HttpClientResponse, RET> responseHandler) throws ResponseException {
        HttpUriRequest request = this.requestBuilder.setConfig(this.requestConfigBuilder.build()).build();
        log.debug("Executing request:{}", (Object)request);
        try (CloseableHttpResponse response = this.httpClient.execute(request, (HttpContext)this.httpClientContext);){
            Object object = responseHandler.handle((Response)new HttpClientResponse(response));
            return (RET)object;
        }
        catch (ClientProtocolException cpe) {
            throw new ResponseProtocolException((Throwable)cpe);
        }
        catch (IOException e) {
            throw new ResponseException((Throwable)e);
        }
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public HttpClientRequest addBasicAuthentication(String hostname, String username, String password) {
        this.httpClientContext.getCredentialsProvider().setCredentials(new AuthScope(hostname, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        this.httpClientContext.getAuthCache().put(new HttpHost(hostname), (AuthScheme)new BasicScheme());
        return this;
    }

    public HttpClientRequest setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
        return this;
    }

    public HttpClientRequest setSoTimeout(int soTimeout) {
        this.requestConfigBuilder.setSocketTimeout(soTimeout);
        return this;
    }

    public HttpClientRequest setUrl(String url) {
        this.requestBuilder.setUri(url);
        return this;
    }

    public HttpClientRequest setRequestBody(String requestBody) {
        return this.setRequestBody(requestBody, ContentType.TEXT_PLAIN.getMimeType());
    }

    public HttpClientRequest setRequestBody(String requestBodyString, String contentTypeString) {
        Preconditions.checkNotNull((Object)requestBodyString);
        Preconditions.checkNotNull((Object)contentTypeString);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        this.requestBuilder.setEntity((HttpEntity)new StringEntity(requestBodyString, ContentType.create((String)contentTypeString, (Charset)StandardCharsets.UTF_8)));
        return this;
    }

    public HttpClientRequest setFiles(List<RequestFilePart> requestBodyFiles) {
        Preconditions.checkNotNull(requestBodyFiles);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (RequestFilePart requestBodyFile : requestBodyFiles) {
            ContentType fileContentType = ContentType.create((String)requestBodyFile.getContentType());
            multipartEntityBuilder.addBinaryBody(requestBodyFile.getParameterName(), requestBodyFile.getFile(), fileContentType, requestBodyFile.getFileName());
        }
        this.requestBuilder.setEntity(multipartEntityBuilder.build());
        return this;
    }

    public HttpClientRequest addRequestParameters(String ... params) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkState((boolean)this.isRequestBodyMethod(), (Object)"Only PUT or POST methods accept a request body.");
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("You must enter an even number of arguments.");
        }
        for (int i = 0; i < params.length; i += 2) {
            String name = params[i];
            String value = params[i + 1];
            this.requestBuilder.addParameter(name, value);
        }
        return this;
    }

    private boolean isRequestBodyMethod() {
        String methodType = this.requestBuilder.getMethod();
        return "POST".equals(methodType) || "PUT".equals(methodType);
    }

    public HttpClientRequest addHeader(String headerName, String headerValue) {
        List<String> list = this.headers.get(headerName);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(headerName, list);
        }
        list.add(headerValue);
        this.requestBuilder.addHeader(headerName, headerValue);
        return this;
    }

    public HttpClientRequest setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, new ArrayList<String>(Arrays.asList(headerValue)));
        this.requestBuilder.setHeader(headerName, headerValue);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean follow) {
        this.requestConfigBuilder.setRedirectsEnabled(follow);
        return this;
    }

    public HttpClientRequest setEntity(Object entity) {
        throw new UnsupportedOperationException("This SAL request does not support object marshalling. Use the RequestFactory component instead.");
    }
}

