/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.core.net.ProxyConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class ProxyRoutePlanner
extends DefaultRoutePlanner {
    private static final String NON_PROXY_WILDCARD = "*";
    private final HttpHost proxy;
    private final String[] nonProxyHosts;

    public ProxyRoutePlanner(ProxyConfig proxyConfig) {
        super(null);
        this.proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
        this.nonProxyHosts = proxyConfig.getNonProxyHosts();
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return this.shouldBeProxied(target.getHostName()) ? this.proxy : null;
    }

    private boolean shouldBeProxied(String host) {
        if (StringUtils.isBlank((String)host)) {
            return false;
        }
        for (String nonProxyHost : this.nonProxyHosts) {
            if (!(nonProxyHost.startsWith(NON_PROXY_WILDCARD) ? host.endsWith(nonProxyHost.substring(1)) : host.equals(nonProxyHost))) continue;
            return false;
        }
        return true;
    }
}

