/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.net.HttpClientProxyConfig;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.trusted.CertificateFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestFactory
implements NonMarshallingRequestFactory<HttpClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestFactory.class);
    private final CertificateFactory certificateFactory;
    private final UserManager userManager;
    public static final int DEFAULT_SOCKET_TIMEOUT = Integer.parseInt(System.getProperty("http.socketTimeout", "10000"));
    public static final int DEFAULT_CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("http.connectionTimeout", "10000"));

    public HttpClientRequestFactory(CertificateFactory certificateFactory, UserManager userManager) {
        this.certificateFactory = certificateFactory;
        this.userManager = userManager;
    }

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        HttpClient httpClient = this.getHttpClient(url);
        return new HttpClientRequest(httpClient, methodType, url, this.certificateFactory, this.userManager);
    }

    protected HttpClient getHttpClient(String url) {
        HttpClient httpClient = new HttpClient();
        this.configureProxy(httpClient, url);
        this.configureConnectionParameters(httpClient);
        return httpClient;
    }

    protected void configureConnectionParameters(HttpClient httpClient) {
        HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
        params.setSoTimeout(DEFAULT_SOCKET_TIMEOUT);
        params.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
    }

    protected void configureProxy(HttpClient client, String remoteUrl) {
        new HttpClientProxyConfig().configureProxy(client, remoteUrl);
    }

    public boolean supportsHeader() {
        return true;
    }
}

