/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.upgrade;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.upgrade.PluginUpgrader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginUpgradeManager
implements PluginUpgradeManager,
LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger log = Logger.getLogger(DefaultPluginUpgradeManager.class);
    private volatile boolean started = false;
    private final List<PluginUpgradeTask> upgradeTasks;
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginEventManager pluginEventManager;

    public DefaultPluginUpgradeManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory) {
        this.upgradeTasks = upgradeTasks;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginEventManager = null;
    }

    public DefaultPluginUpgradeManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory, PluginEventManager pluginEventManager) {
        this.upgradeTasks = upgradeTasks;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginEventManager = pluginEventManager;
    }

    @Deprecated
    public void onBind(PluginUpgradeTask task, Map props) {
        log.debug((Object)("onbind task = [" + task.getPluginKey() + ", " + task.getBuildNumber() + "] "));
    }

    public void onStart() {
        log.debug((Object)"onStart");
        List<Message> messages = this.upgrade();
        if (messages != null) {
            for (Message msg : messages) {
                log.error((Object)("Upgrade error: " + msg));
            }
        }
        this.started = true;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        List<Message> messages;
        if (this.started && (messages = this.upgradeInTransaction(event.getPlugin())) != null && messages.size() > 0) {
            log.error((Object)("Error(s) encountered while upgrading plugin '" + event.getPlugin().getName() + "' on enable."));
            for (Message msg : messages) {
                log.error((Object)("Upgrade error: " + msg));
            }
        }
    }

    protected Map<String, List<PluginUpgradeTask>> getUpgradeTasks() {
        HashMap<String, List<PluginUpgradeTask>> pluginUpgrades = new HashMap<String, List<PluginUpgradeTask>>();
        for (PluginUpgradeTask upgradeTask : this.upgradeTasks) {
            ArrayList<PluginUpgradeTask> upgrades = (ArrayList<PluginUpgradeTask>)pluginUpgrades.get(upgradeTask.getPluginKey());
            if (upgrades == null) {
                upgrades = new ArrayList<PluginUpgradeTask>();
                pluginUpgrades.put(upgradeTask.getPluginKey(), upgrades);
            }
            upgrades.add(upgradeTask);
        }
        return pluginUpgrades;
    }

    public List<Message> upgrade() {
        List messages = (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return DefaultPluginUpgradeManager.this.upgradeInternal();
            }
        });
        return messages;
    }

    public List<Message> upgradeInternal() {
        log.info((Object)"Running plugin upgrade tasks...");
        Map<String, List<PluginUpgradeTask>> pluginUpgrades = this.getUpgradeTasks();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String pluginKey : pluginUpgrades.keySet()) {
            List<PluginUpgradeTask> upgrades;
            List<Message> upgradeMessages = this.upgradePlugin(pluginKey, upgrades = pluginUpgrades.get(pluginKey));
            if (upgradeMessages == null) continue;
            messages.addAll(upgradeMessages);
        }
        return messages;
    }

    private List<Message> upgradeInTransaction(final Plugin plugin) {
        List messages = (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return DefaultPluginUpgradeManager.this.upgradeInternal(plugin);
            }
        });
        return messages;
    }

    public List<Message> upgradeInternal(Plugin plugin) {
        String pluginKey;
        Map<String, List<PluginUpgradeTask>> pluginUpgrades = this.getUpgradeTasks();
        List<PluginUpgradeTask> upgrades = pluginUpgrades.get(pluginKey = plugin.getKey());
        if (upgrades == null) {
            return null;
        }
        return this.upgradePlugin(pluginKey, upgrades);
    }

    private List<Message> upgradePlugin(String pluginKey, List<PluginUpgradeTask> upgrades) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            throw new IllegalArgumentException("Invalid plugin key: " + pluginKey);
        }
        PluginUpgrader pluginUpgrader = new PluginUpgrader(plugin, this.pluginSettingsFactory.createGlobalSettings(), upgrades);
        List<Message> upgradeMessages = pluginUpgrader.upgrade();
        return upgradeMessages;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.pluginEventManager != null) {
            this.pluginEventManager.register((Object)this);
        }
    }

    public void destroy() throws Exception {
        if (this.pluginEventManager != null) {
            this.pluginEventManager.unregister((Object)this);
        }
    }
}

