/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientResponse
implements Response {
    private final HttpMethod method;

    public HttpClientResponse(HttpMethod method) {
        this.method = method;
    }

    public String getResponseBodyAsString() throws ResponseException {
        try {
            return this.method.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new ResponseException(e.getMessage(), (Throwable)e);
        }
    }

    public InputStream getResponseBodyAsStream() throws ResponseException {
        try {
            return this.method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new ResponseException(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T getEntity(Class<T> entityClass) throws ResponseException {
        throw new UnsupportedOperationException("This SAL request does not support object marshalling. Use the RequestFactory component instead.");
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public String getStatusText() {
        return this.method.getStatusText();
    }

    public boolean isSuccessful() {
        int codeOrder = this.method.getStatusCode() / 100;
        return codeOrder == 2 || codeOrder == 3;
    }

    public String getHeader(String name) {
        return this.method.getResponseHeader(name).getValue();
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : this.method.getResponseHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }
}

