/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.features;

import com.atlassian.sal.api.features.SiteDarkFeaturesStorage;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultSiteDarkFeaturesStorage
implements SiteDarkFeaturesStorage {
    private static final String SITE_WIDE_DARK_FEATURES = "atlassian.sitewide.dark.features";
    private final ResettableLazyReference<ImmutableSet<String>> cache = new ResettableLazyReference<ImmutableSet<String>>(){

        protected ImmutableSet<String> create() throws Exception {
            return ImmutableSet.copyOf((Collection)DefaultSiteDarkFeaturesStorage.this.load());
        }
    };
    private final PluginSettingsFactory pluginSettingsFactory;

    public DefaultSiteDarkFeaturesStorage(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void enable(String featureKey) {
        String trimmedFeatureKey = (String)Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)featureKey), (Object)"featureKey must not be blank");
        if (!((ImmutableSet)this.cache.get()).contains((Object)trimmedFeatureKey)) {
            this.update(this.addFeatureKey(trimmedFeatureKey));
            this.cache.reset();
        }
    }

    public void disable(String featureKey) {
        String trimmedFeatureKey = (String)Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)featureKey), (Object)"featureKey must not be blank");
        if (((ImmutableSet)this.cache.get()).contains((Object)trimmedFeatureKey)) {
            this.update(this.removeFeatureKey(trimmedFeatureKey));
            this.cache.reset();
        }
    }

    public ImmutableSet<String> getEnabledDarkFeatures() {
        return (ImmutableSet)this.cache.get();
    }

    private synchronized void update(Function<List<String>, List<String>> transformer) {
        List<String> storedFeatureKeys = this.load();
        List updatedFeatureKeys = (List)transformer.apply(storedFeatureKeys);
        this.store(updatedFeatureKeys);
    }

    private synchronized List<String> load() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = globalSettings.get(SITE_WIDE_DARK_FEATURES);
        return this.extractFeatureKeys(value);
    }

    private List<String> extractFeatureKeys(@Nullable Object value) {
        LinkedList<String> storedFeatureKeys = new LinkedList<String>();
        if (value instanceof List) {
            List list = (List)List.class.cast(value);
            for (Object listItem : list) {
                if (!(listItem instanceof String)) continue;
                storedFeatureKeys.addLast((String)String.class.cast(listItem));
            }
        }
        return storedFeatureKeys;
    }

    private synchronized void store(List<String> updatedFeatureKeys) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(SITE_WIDE_DARK_FEATURES, updatedFeatureKeys);
    }

    private Function<List<String>, List<String>> addFeatureKey(final String featureKey) {
        return new Function<List<String>, List<String>>(){

            public List<String> apply(@Nullable List<String> storedFeatureKeys) {
                if (storedFeatureKeys == null) {
                    return storedFeatureKeys;
                }
                ArrayList<String> result = new ArrayList<String>(storedFeatureKeys);
                if (!storedFeatureKeys.contains(featureKey)) {
                    result.add(featureKey);
                }
                return result;
            }
        };
    }

    private Function<List<String>, List<String>> removeFeatureKey(final String featureKey) {
        return new Function<List<String>, List<String>>(){

            public List<String> apply(@Nullable List<String> storedFeatureKeys) {
                if (storedFeatureKeys == null) {
                    return storedFeatureKeys;
                }
                ArrayList<String> result = new ArrayList<String>(storedFeatureKeys);
                result.remove(featureKey);
                return result;
            }
        };
    }
}

