/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.scheduling;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzPluginScheduler
implements PluginScheduler {
    private static final String JOB_CLASS_KEY = "pluginJobClass";
    private static final String JOB_DATA_MAP_KEY = "pluginJobDataMap";
    private static final Logger log = LoggerFactory.getLogger(QuartzPluginScheduler.class);
    private static final String DEFAULT_GROUP = "pluginSchedulerJobGroup";

    public void scheduleJob(String name, Class<? extends PluginJob> job, Map<String, Object> jobDataMap, Date startTime, long repeatInterval) {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setGroup(DEFAULT_GROUP);
        jobDetail.setName(name);
        jobDetail.setJobClass(QuartzPluginJob.class);
        jobDetail.setJobDataMap(this.getJobMap(job, jobDataMap));
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setGroup("pluginSchedulerTriggerGroup");
        trigger.setName(name + "Trigger");
        if (startTime != null) {
            trigger.setStartTime(startTime);
        }
        if (repeatInterval == 0L) {
            trigger.setRepeatCount(0);
        } else {
            trigger.setRepeatInterval(repeatInterval);
            trigger.setRepeatCount(-1);
        }
        try {
            Scheduler scheduler = this.getScheduler();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException se) {
            log.error("Error scheduling job " + name, (Throwable)se);
        }
    }

    public void unscheduleJob(String name) {
        try {
            Scheduler scheduler = this.getScheduler();
            if (!Arrays.asList(scheduler.getJobNames(DEFAULT_GROUP)).contains(name)) {
                throw new IllegalArgumentException("Error unscheduling job. Job '" + name + "' is not scheduled ");
            }
            scheduler.deleteJob(name, DEFAULT_GROUP);
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException("Error unscheduling job " + name, e);
        }
    }

    protected JobDataMap getJobMap(Class<? extends PluginJob> job, Map<String, Object> jobDataMap) {
        JobDataMap jobDetailMap = new JobDataMap();
        jobDetailMap.put((Object)JOB_CLASS_KEY, job);
        jobDetailMap.put((Object)JOB_DATA_MAP_KEY, jobDataMap);
        return jobDetailMap;
    }

    protected Scheduler getScheduler() {
        return (Scheduler)ComponentLocator.getComponent(Scheduler.class);
    }

    public static class QuartzPluginJob
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            PluginJob job;
            JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
            Class jobClass = (Class)map.get((Object)QuartzPluginScheduler.JOB_CLASS_KEY);
            Map pluginJobMap = (Map)map.get((Object)QuartzPluginScheduler.JOB_DATA_MAP_KEY);
            try {
                job = (PluginJob)jobClass.newInstance();
            }
            catch (InstantiationException ie) {
                throw new JobExecutionException("Error instantiating job", (Throwable)ie, false);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException("Cannot access job class", (Throwable)iae, false);
            }
            job.execute(pluginJobMap);
        }
    }
}

