/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateCallable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadLocalDelegateExecutorService<C>
implements ExecutorService {
    protected final ThreadLocalContextManager<C> manager;
    private final ExecutorService delegate;

    public ThreadLocalDelegateExecutorService(ThreadLocalContextManager<C> manager, ExecutorService delegate) {
        this.manager = (ThreadLocalContextManager)Preconditions.checkNotNull(manager);
        this.delegate = (ExecutorService)Preconditions.checkNotNull((Object)delegate);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(this.threadLocalDelegateCallable(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(this.threadLocalDelegateRunnable(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(this.threadLocalDelegateRunnable(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        return this.delegate.invokeAll(this.threadLocalDelegateCallableCollection(callables));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.threadLocalDelegateCallableCollection(callables), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.threadLocalDelegateCallableCollection(callables));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.threadLocalDelegateCallableCollection(callables), timeout, unit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.threadLocalDelegateRunnable(runnable));
    }

    private ThreadLocalDelegateRunnable threadLocalDelegateRunnable(Runnable runnable) {
        return new ThreadLocalDelegateRunnable<C>(this.manager, runnable);
    }

    private <T> ThreadLocalDelegateCallable<C, T> threadLocalDelegateCallable(Callable<T> callable) {
        return new ThreadLocalDelegateCallable<C, T>(this.manager, callable);
    }

    private <T> Collection<ThreadLocalDelegateCallable<C, T>> threadLocalDelegateCallableCollection(Collection<? extends Callable<T>> callables) {
        return Collections2.transform(callables, (Function)new Function<Callable<T>, ThreadLocalDelegateCallable<C, T>>(){

            public ThreadLocalDelegateCallable<C, T> apply(Callable<T> callable) {
                return ThreadLocalDelegateExecutorService.this.threadLocalDelegateCallable(callable);
            }
        });
    }
}

