/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;

class CustomSSLProtocolSocketFactory
extends SSLProtocolSocketFactory {
    private final String[] protocols;

    public CustomSSLProtocolSocketFactory(String protocols) {
        String protocolsProperty = System.getProperty("https.protocols", protocols);
        if (protocolsProperty == null) {
            protocolsProperty = CustomSSLProtocolSocketFactory.getSupportedSSLProtocols();
        }
        this.protocols = protocolsProperty.split(",");
    }

    public static String getSupportedSSLProtocols() {
        StringBuilder sb = new StringBuilder();
        try {
            for (String protocol : SSLContext.getDefault().getSupportedSSLParameters().getProtocols()) {
                if (protocol.equals("SSLv2Hello")) continue;
                sb.append(protocol).append(",");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String protocols = sb.toString();
        if (protocols.endsWith(",")) {
            protocols = protocols.substring(0, protocols.length() - 1);
        }
        return protocols;
    }

    private void setSocketProtocols(Socket socket) {
        SSLSocket sslSocket = (SSLSocket)socket;
        sslSocket.setEnabledProtocols(this.protocols);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        Socket socket = super.createSocket(host, port, clientHost, clientPort);
        this.setSocketProtocols(socket);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket = super.createSocket(host, port, localAddress, localPort, params);
        this.setSocketProtocols(socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = super.createSocket(host, port);
        this.setSocketProtocols(socket);
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket newSocket = super.createSocket(socket, host, port, autoClose);
        this.setSocketProtocols(newSocket);
        return newSocket;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomSSLProtocolSocketFactory that = (CustomSSLProtocolSocketFactory)((Object)o);
        return Arrays.equals(this.protocols, that.protocols);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.protocols != null ? Arrays.hashCode(this.protocols) : 0);
        return result;
    }
}

