/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;

class ThreadLocalDelegateExecutor<C>
implements Executor {
    private final Executor delegate;
    protected final ThreadLocalContextManager<C> manager;

    ThreadLocalDelegateExecutor(ThreadLocalContextManager<C> manager, Executor delegate) {
        this.delegate = (Executor)Preconditions.checkNotNull((Object)delegate);
        this.manager = (ThreadLocalContextManager)Preconditions.checkNotNull(manager);
    }

    @Override
    public void execute(Runnable runnable) {
        ThreadLocalDelegateRunnable<C> wrapper = new ThreadLocalDelegateRunnable<C>(this.manager, runnable);
        this.delegate.execute(wrapper);
    }
}

