/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.core.net.CustomSSLProtocolSocketFactory;
import java.net.URI;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

class HttpClientProtocolConfig {
    HttpClientProtocolConfig() {
    }

    static void configureProtocol(HttpClient httpClient, String url) {
        HttpClientProtocolConfig.changeHostConfigurationProtocol(httpClient, url, "TLSv1,SSLv3");
    }

    static void changeHostConfigurationProtocol(HttpClient httpClient, String sslProtocols) {
        HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
        String host = hostConfiguration.getHost();
        int port = hostConfiguration.getPort();
        String scheme = hostConfiguration.getProtocol().getScheme();
        HttpClientProtocolConfig.changeHostConfigurationProtocol(hostConfiguration, host, port, scheme, sslProtocols);
    }

    private static void changeHostConfigurationProtocol(HttpClient httpClient, String remoteUrl, String sslProtocols) {
        URI url = URI.create(remoteUrl);
        String host = url.getHost();
        int port = url.getPort();
        String scheme = url.getScheme();
        HttpClientProtocolConfig.changeHostConfigurationProtocol(httpClient.getHostConfiguration(), host, port, scheme, sslProtocols);
    }

    private static void changeHostConfigurationProtocol(HostConfiguration hostConfiguration, String host, int port, String scheme, String sslProtocols) {
        if ("https".equals(scheme)) {
            port = port == -1 ? 443 : port;
            Protocol customHttpsProtocol = new Protocol("https", (SecureProtocolSocketFactory)new CustomSSLProtocolSocketFactory(sslProtocols), port);
            hostConfiguration.setHost(host, port, customHttpsProtocol);
        } else {
            port = port == -1 ? 80 : port;
            hostConfiguration.setHost(host, port);
        }
    }
}

