/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.lifecycle;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.lifecycle.LifecycleManager;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultLifecycleManager
implements LifecycleManager {
    private boolean started = false;
    private static final Logger log = Logger.getLogger(DefaultLifecycleManager.class);
    private List<LifecycleAware> listeners;

    @PluginEventListener
    public void onFrameworkStart(PluginFrameworkStartedEvent event) {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.started && this.isApplicationSetUp()) {
            try {
                this.notifyOnStart();
            }
            finally {
                this.started = true;
            }
        }
    }

    public synchronized void onBind(LifecycleAware service, Map properties) {
        if (this.started) {
            this.notifyLifecycleAwareOfStart(service);
        }
    }

    protected void notifyOnStart() {
        for (LifecycleAware entry : this.listeners) {
            this.notifyLifecycleAwareOfStart(entry);
        }
    }

    private void notifyLifecycleAwareOfStart(LifecycleAware entry) {
        try {
            entry.onStart();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unable to start component: " + entry.getClass().getName()), (Throwable)ex);
        }
    }

    public void setListeners(List<LifecycleAware> listeners) {
        this.listeners = listeners;
    }

    public void setPluginEventManager(PluginEventManager pluginEventManager) {
        pluginEventManager.register((Object)this);
    }
}

