/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.auth.Authenticator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.net.HttpClientResponse;
import com.atlassian.sal.core.net.auth.BaseAuthenticator;
import com.atlassian.sal.core.net.auth.HttpClientAuthenticator;
import com.atlassian.sal.core.net.auth.SeraphAuthenticator;
import com.atlassian.sal.core.net.auth.TrustedTokenAuthenticator;
import com.atlassian.sal.core.trusted.CertificateFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientRequest
implements Request<HttpClientRequest, HttpClientResponse> {
    private static final Logger log = Logger.getLogger(HttpClientRequest.class);
    public static final int MAX_REDIRECTS = 3;
    private final Request.MethodType methodType;
    private String url;
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<HttpClientAuthenticator> authenticators = new ArrayList<HttpClientAuthenticator>();
    private final CertificateFactory certificateFactory;
    private final HttpClient httpClient;
    private final UserManager userManager;
    private String requestBody;
    private String requestContentType;

    public HttpClientRequest(HttpClient httpClient, Request.MethodType methodType, String url, CertificateFactory certificateFactory, UserManager userManager) {
        this.httpClient = httpClient;
        this.methodType = methodType;
        this.url = url;
        this.certificateFactory = certificateFactory;
        this.userManager = userManager;
    }

    public HttpClientRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpClientRequest addAuthentication(Authenticator authenticator) {
        if (authenticator instanceof HttpClientAuthenticator) {
            this.authenticators.add((HttpClientAuthenticator)authenticator);
        } else {
            log.warn((Object)("Authenticator '" + authenticator + "'is not instance of " + HttpClientAuthenticator.class.getName()));
        }
        return this;
    }

    public HttpClientRequest addTrustedTokenAuthentication() {
        TrustedTokenAuthenticator trustedTokenAuthenticator = new TrustedTokenAuthenticator(this.userManager.getRemoteUsername(), this.certificateFactory);
        this.authenticators.add(trustedTokenAuthenticator);
        return this;
    }

    public HttpClientRequest addTrustedTokenAuthentication(String username) {
        TrustedTokenAuthenticator trustedTokenAuthenticator = new TrustedTokenAuthenticator(username, this.certificateFactory);
        this.authenticators.add(trustedTokenAuthenticator);
        return this;
    }

    public HttpClientRequest addBasicAuthentication(String username, String password) {
        this.authenticators.add(new BaseAuthenticator(username, password));
        return this;
    }

    public HttpClientRequest addSeraphAuthentication(String username, String password) {
        this.authenticators.add(new SeraphAuthenticator(username, password));
        return this;
    }

    public HttpClientRequest setConnectionTimeout(int connectionTimeout) {
        HttpConnectionManagerParams params = this.httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public HttpClientRequest setSoTimeout(int soTimeout) {
        HttpConnectionManagerParams params = this.httpClient.getHttpConnectionManager().getParams();
        params.setSoTimeout(soTimeout);
        return this;
    }

    public HttpClientRequest setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        if (this.methodType != Request.MethodType.POST && this.methodType != Request.MethodType.PUT) {
            throw new IllegalArgumentException("Only POST and PUT methods can have request body");
        }
        return this;
    }

    public HttpClientRequest setEntity(Object entity) {
        throw new UnsupportedOperationException("This SAL request does not support object marshaling. Use the RequestFactory component instead.");
    }

    public HttpClientRequest setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
        return this;
    }

    public HttpClientRequest addRequestParameters(String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("You must enter even number of arguments");
        }
        if (this.methodType != Request.MethodType.POST && this.methodType != Request.MethodType.PUT) {
            throw new IllegalArgumentException("Only POST and PUT methods accept req");
        }
        for (int i = 0; i < params.length; i += 2) {
            String name = params[i];
            String value = params[i + 1];
            List<String> list = this.parameters.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.parameters.put(name, list);
            }
            list.add(value);
        }
        return this;
    }

    public HttpClientRequest addHeader(String headerName, String headerValue) {
        List<String> list = this.headers.get(headerName);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(headerName, list);
        }
        list.add(headerValue);
        return this;
    }

    public HttpClientRequest setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, new ArrayList<String>(Arrays.asList(headerValue)));
        return this;
    }

    public HttpClientRequest addHeaders(String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("You must enter even number of arguments");
        }
        for (int i = 0; i < params.length; i += 2) {
            String name = params[i];
            String value = params[i + 1];
            List<String> list = this.headers.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(name, list);
            }
            list.add(value);
        }
        return this;
    }

    public void execute(ResponseHandler<HttpClientResponse> responseHandler) throws ResponseException {
        HttpMethod method = this.makeMethod();
        this.processHeaders(method);
        this.processAuthenticator(method);
        this.processParameters(method);
        if (log.isDebugEnabled()) {
            Header[] requestHeaders = method.getRequestHeaders();
            log.debug((Object)("Calling " + method.getName() + " " + this.url + " with headers " + (requestHeaders == null ? "none" : Arrays.asList(requestHeaders).toString())));
        }
        method.setRequestHeader("Connection", "close");
        try {
            this.executeMethod(method, 0);
            responseHandler.handle((Response)new HttpClientResponse(method));
        }
        catch (IOException ioe) {
            throw new ResponseException((Throwable)ioe);
        }
        finally {
            HttpClientRequest.exhaustResponseContents(method);
            method.releaseConnection();
            HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
            if (httpConnectionManager != null) {
                httpConnectionManager.closeIdleConnections(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exhaustResponseContents(HttpMethod response) {
        InputStream body = null;
        try {
            body = response.getResponseBodyAsStream();
            if (body == null) {
                return;
            }
            byte[] buf = new byte[512];
            int bytesRead = 0;
            while ((bytesRead = body.read(buf)) != -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            HttpClientRequest.shutdownStream(body);
        }
    }

    public static void shutdownStream(InputStream input) {
        if (null == input) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String execute() throws ResponseException {
        final HashSet stringHolder = new HashSet();
        this.execute(new ResponseHandler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) throws ResponseException {
                if (!response.isSuccessful()) {
                    throw new ResponseException("Unexpected response received. Status code: " + response.getStatusCode());
                }
                stringHolder.add(response.getResponseBodyAsString());
            }
        });
        return stringHolder.isEmpty() ? "" : (String)stringHolder.iterator().next();
    }

    protected HttpMethod makeMethod() {
        PostMethod method;
        switch (this.methodType) {
            case POST: {
                method = new PostMethod(this.url);
                break;
            }
            case PUT: {
                method = new PutMethod(this.url);
                break;
            }
            case DELETE: {
                method = new DeleteMethod(this.url);
                break;
            }
            case OPTIONS: {
                method = new OptionsMethod(this.url);
                break;
            }
            case HEAD: {
                method = new HeadMethod(this.url);
                break;
            }
            case TRACE: {
                method = new TraceMethod(this.url);
                break;
            }
            default: {
                method = new GetMethod(this.url);
            }
        }
        return method;
    }

    private void executeMethod(HttpMethod method, int redirectCounter) throws IOException {
        if (++redirectCounter > 3) {
            throw new IOException("Maximum number of redirects (3) reached.");
        }
        int statusCode = this.httpClient.executeMethod(method);
        if (statusCode >= 300 && statusCode <= 399) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                method.setURI(new URI(redirectLocation, true));
                this.executeMethod(method, redirectCounter);
            } else {
                throw new IOException("HTTP response returned redirect code " + statusCode + " but did not provide a location header");
            }
        }
    }

    private void processHeaders(HttpMethod method) {
        for (String headerName : this.headers.keySet()) {
            for (String headerValue : this.headers.get(headerName)) {
                method.addRequestHeader(headerName, headerValue);
            }
        }
    }

    private void processParameters(HttpMethod method) {
        if (!(method instanceof EntityEnclosingMethod)) {
            return;
        }
        if (method instanceof PostMethod && !this.parameters.isEmpty()) {
            PostMethod postMethod = (PostMethod)method;
            postMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            for (String parameterName : this.parameters.keySet()) {
                for (String parameterValue : this.parameters.get(parameterName)) {
                    postMethod.addParameter(parameterName, parameterValue);
                }
            }
            return;
        }
        if (this.requestBody != null) {
            ByteArrayInputStream inputStream;
            EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)method;
            String contentType = this.requestContentType + "; charset=UTF-8";
            try {
                inputStream = new ByteArrayInputStream(this.requestBody.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            entityEnclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)inputStream, contentType));
        }
    }

    private void processAuthenticator(HttpMethod method) {
        for (HttpClientAuthenticator authenticator : this.authenticators) {
            authenticator.process(this.httpClient, method);
        }
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Request.MethodType getMethodType() {
        return this.methodType;
    }

    public String toString() {
        return this.methodType + " " + this.url + ", Parameters: " + this.parameters + (StringUtils.isBlank((String)this.requestBody) ? "" : "\nRequest body:\n" + this.requestBody);
    }
}

