/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.pluginsettings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public abstract class AbstractStringPluginSettings
implements PluginSettings {
    private static final Logger log = Logger.getLogger(AbstractStringPluginSettings.class);
    private static final String PROPERTIES_ENCODING = "ISO8859_1";
    private static final String PROPERTIES_IDENTIFIER = "java.util.Properties";
    private static final String LIST_IDENTIFIER = "#java.util.List";
    private static final String MAP_IDENTIFIER = "#java.util.Map";
    private static final String VERTICAL_TAB = "\f";

    public Object put(String key, Object value) {
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        if (value == null) {
            return this.remove(key);
        }
        Object oldValue = this.get(key);
        if (value instanceof Properties) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                Properties properties = (Properties)value;
                properties.store(bout, PROPERTIES_IDENTIFIER);
                this.putActual(key, new String(bout.toByteArray(), PROPERTIES_ENCODING));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to serialize properties", e);
            }
        } else if (value instanceof String) {
            this.putActual(key, (String)value);
        } else if (value instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append(LIST_IDENTIFIER).append("\n");
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append('\n');
            }
            this.putActual(key, sb.toString());
        } else if (value instanceof Map) {
            StringBuilder sb = new StringBuilder();
            sb.append(MAP_IDENTIFIER).append("\n");
            Iterator i = ((Map)value).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                sb.append(entry.getKey().toString());
                sb.append(VERTICAL_TAB);
                sb.append(entry.getValue().toString());
                if (!i.hasNext()) continue;
                sb.append('\n');
            }
            this.putActual(key, sb.toString());
        } else {
            throw new IllegalArgumentException("Property type: " + value.getClass() + " not supported");
        }
        return oldValue;
    }

    public Object get(String key) {
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        String val = this.getActual(key);
        if (val != null && val.startsWith("#java.util.Properties")) {
            Properties p = new Properties();
            try {
                p.load(new ByteArrayInputStream(val.getBytes(PROPERTIES_ENCODING)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to deserialize properties", e);
            }
            return p;
        }
        if (val != null && val.startsWith(LIST_IDENTIFIER)) {
            String[] items = val.split("\n");
            ArrayList<String> list = new ArrayList<String>(items.length - 1);
            list.addAll(Arrays.asList(items).subList(1, items.length));
            return list;
        }
        if (val != null && val.startsWith(MAP_IDENTIFIER)) {
            String[] items;
            String nval = val.substring(MAP_IDENTIFIER.length() + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String item : items = nval.split("\n")) {
                String[] pair = item.split(VERTICAL_TAB);
                if (pair.length != 2) {
                    log.error((Object)("Could not parse map element: << " + item + " >> \n" + "Full list: \n" + nval));
                }
                map.put(pair[0], pair[1]);
            }
            return map;
        }
        return val;
    }

    public Object remove(String key) {
        Validate.notNull((Object)key, (String)"The plugin settings key cannot be null");
        Object oldValue = this.get(key);
        if (oldValue != null) {
            this.removeActual(key);
        }
        return oldValue;
    }

    protected abstract void putActual(String var1, String var2);

    protected abstract String getActual(String var1);

    protected abstract void removeActual(String var1);
}

