/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.pluginsettings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class AbstractStringPluginSettings
implements PluginSettings {
    private static final String PROPERTIES_ENCODING = "ISO8859_1";
    private static final String PROPERTIES_IDENTIFIER = "java.util.Properties";
    private static final String LIST_IDENTIFIER = "java.util.List";

    public Object put(String key, Object val) {
        if (val == null) {
            return this.removeActual(key);
        }
        if (val instanceof Properties) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                Properties properties = (Properties)val;
                properties.store(bout, PROPERTIES_IDENTIFIER);
                this.putActual(key, new String(bout.toByteArray(), PROPERTIES_ENCODING));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to serialize properties", e);
            }
        } else if (val instanceof String) {
            this.putActual(key, (String)val);
        } else if (val instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append("#java.util.List\n");
            Iterator i = ((List)val).iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append('\n');
            }
            this.putActual(key, sb.toString());
        } else {
            throw new IllegalArgumentException("Property type: " + val.getClass() + " not supported");
        }
        return val;
    }

    public Object get(String key) {
        String val = this.getActual(key);
        if (val != null && val.startsWith("#java.util.Properties")) {
            Properties p = new Properties();
            try {
                p.load(new ByteArrayInputStream(val.getBytes(PROPERTIES_ENCODING)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to deserialize properties", e);
            }
            return p;
        }
        if (val != null && val.startsWith("#java.util.List")) {
            ArrayList<String> list = new ArrayList<String>();
            String[] items = val.split("\n");
            for (int x = 1; x < items.length; ++x) {
                list.add(items[x]);
            }
            return list;
        }
        return val;
    }

    protected abstract void putActual(String var1, String var2);

    protected abstract String getActual(String var1);

    protected abstract Object removeActual(String var1);

    public Object remove(String key) {
        return this.put(key, null);
    }
}

