/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.core.executor.ThreadLocalContextManager;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadLocalDelegateCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final ThreadLocalContextManager manager;
    private final Object context;
    private final ClassLoader contextClassLoader;

    ThreadLocalDelegateCallable(ThreadLocalContextManager manager, Callable<T> delegate) {
        this.delegate = delegate;
        this.manager = manager;
        this.context = manager.getThreadLocalContext();
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            this.manager.setThreadLocalContext(this.context);
            T t = this.delegate.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            this.manager.clearThreadLocalContext();
        }
    }
}

