package com.atlassian.sal.api.websudo.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import com.atlassian.sal.api.websudo.WebSudoManager;

/**
 * Allows the client to integrate with the product's native Websudo functionality.
 *
 * @since 7.0
 */
public interface InternalWebSudoManager extends WebSudoManager {

    /**
     * Returns whether the current request is allowed to hold a web sudo session.
     * <p>
     * Reasons why a request may not be allowed to hold a web sudo session include but are not limited to:
     * <ul>
     *     <li>The request is {@code null}</li>
     *     <li>The request's session is {@code null}</li>
     *     <li>The web sudo feature is disabled</li>
     *     <li>Product is in development mode</li>
     *     <li>The requesting user does not have sufficient permissions</li>
     *     <li>The request is coming from a non-allowlisted IP address</li>
     * </ul>
     *
     * @param request the current request
     * @return {@code true} if the request will be allowed to attempt web sudo access. {@code false} otherwise
     */
    boolean canHoldWebSudoSession(HttpServletRequest request);

    /**
     * Creates a new web sudo session for the current user. The session will only be created when the user
     * is allowed to hold a web sudo session (see {@link #canHoldWebSudoSession(HttpServletRequest)}).
     *
     * @param request the current request
     * @param response the current response
     */
    void createWebSudoSession(HttpServletRequest request, HttpServletResponse response);
}
