/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class HaskellFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = HaskellFormatter.individualWords(new String[]{"as", "case", "class[^=]", "data", "data", "default", "deriving", "do", "else", "false", "family", "forall", "foreign", "hiding", "if", "import", "in", "infix", "infixl", "infixr", "instance", "let", "mdo", "module", "newtype", "of", "proc", "qualified", "rec", "then", "true", "type", "where"});
    private static final String OBJECTS = HaskellFormatter.individualWords(new String[]{"Bool", "Bounded", "Either", "Enum", "Eq", "Floating", "Fractional", "Functor", "IO", "Integral", "Maybe", "Monad", "MonadPlus", "Num", "Ord", "Ordering", "Read", "Real", "RealFloat", "RealFrac", "Show", "String"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"haskell"};

    public HaskellFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("--(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

