/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class YamlFormatter
extends AbstractFormatter {
    private static final String NUMBERS = "([0-9]+)";
    private static final String KEYS = "([a-zA-Z0-9]+\\:)\\s{1}";
    private static final String KEYS_REPLACEMENT = "<span class=\"code-keyword\">$1 </span>";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"yaml"};

    public YamlFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement(NUMBERS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYS, KEYS_REPLACEMENT);
        this.addReplacement("#(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

