/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class RubyFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = RubyFormatter.individualWords(new String[]{"__ENCODING__", "__LINE__", "__FILE__", "BEGIN", "END", "alias", "and", "begin", "break", "case", "class[^=]", "def", "defined\\??", "do", "else", "elsif", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield", "=begin", "=end"});
    private static final String OBJECTS = RubyFormatter.individualWords(new String[]{"Array", "Bignum", "FalseClass", "Fixnum", "Float", "Hash", "Integer", "NilClass", "Numeric", "Range", "String", "Symbol", "TrueClass"});
    private static final String ATS = "(@[A-Za-z0-9]+)\\s{1}";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"ruby"};

    public RubyFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("#(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(ATS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

