/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class GroovyFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = GroovyFormatter.individualWords(new String[]{"as", "assert", "break", "case", "catch", "class[^=]", "const", "continue", "def", "default", "do", "else", "enum", "extends", "false", "finally", "for", "goto", "if", "implements", "import", "in", "instanceof", "interface", "new", "null", "package", "return", "super", "switch", "this", "throw", "throws", "trait", "true", "try", "while"});
    private static final String OBJECTS = GroovyFormatter.individualWords(new String[]{"Boolean", "Byte", "Character", "Class", "ClassLoader", "Cloneable", "Compiler", "Double", "Float", "Integer", "Long", "Math", "Number", "Object", "Process", "Runnable", "Runtime", "SecurityManager", "Short", "String", "StringBuffer", "System", "Thread", "ThreadGroup", "Void", "boolean", "char", "byte", "short", "int", "long", "float", "double"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"groovy"};

    public GroovyFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

