/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class GoFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = GoFormatter.individualWords(new String[]{"break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var"});
    private static final String OBJECTS = GoFormatter.individualWords(new String[]{"byte", "complex64", "complex128", "float32", "float64", "int", "int8", "int16", "int32", "int64", "rune", "string", "uint", "uint8", "uint16", "uint32", "uint64", "uintptr"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"go"};

    public GoFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("(`|\\&#96;)(.+?)(?<!(`|\\&#96;))(`|\\&#96;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

