/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.basic;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.log4j.Category;

public class BasicAnchorMacro
extends BaseMacro {
    private static final Category log = Category.getInstance(BasicAnchorMacro.class);

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.INLINE;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (!TextUtils.stringSet((String)((String)parameters.get("0")))) {
            return "";
        }
        return "<a name=\"" + BasicAnchorMacro.getAnchor(renderContext, (String)parameters.get("0")) + "\">" + body + "</a>";
    }

    public static String getAnchor(RenderContext context, String body) {
        String result = "";
        result = result + RendererUtil.summarise(TextUtils.noNull((String)RenderedContentStore.stripTokens(body)).trim());
        result = result.replaceAll(" ", "");
        try {
            result = URLEncoder.encode(result, context.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Unable to escape anchor value because of an unsupported character encoding of: " + context.getCharacterEncoding()));
        }
        return result;
    }
}

