/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.phrase;

import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.util.RegExpUtil;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.Replacer;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import com.atlassian.renderer.v2.components.TextConverter;
import com.atlassian.renderer.v2.components.phrase.PhraseRendererComponent;
import com.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class EmoticonRendererComponent
extends AbstractRegexRendererComponent
implements TextConverter {
    public static final String MAX_EMOTICONS_TO_RENDER_SYSTEM_PROPERTY_KEY = "atlassian.renderer.max.emoticons";
    private static final Logger log = Logger.getLogger(EmoticonRendererComponent.class);
    private final int MAX_EMOTICONS = Integer.getInteger("atlassian.renderer.max.emoticons", Integer.MAX_VALUE);
    private final IconManager iconManager;
    private final LazyReference<Emoticons> emoticons;

    public EmoticonRendererComponent(final IconManager iconManager) {
        this.iconManager = iconManager;
        this.emoticons = new LazyReference<Emoticons>(){

            protected Emoticons create() throws Exception {
                return new Emoticons(iconManager.getEmoticonSymbols());
            }
        };
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderPhrases();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        return ((Emoticons)this.emoticons.get()).render(wiki, context);
    }

    @Override
    public String convertToWikiMarkup(String text) {
        return ((Emoticons)this.emoticons.get()).toWikiMarkup(text);
    }

    @Override
    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String match = matcher.group(0);
        if (match.startsWith("\\")) {
            buffer.append(match.substring(1));
        } else {
            buffer.append(this.iconManager.getEmoticon(match).toHtml(context.getImagePath()));
        }
    }

    int maxEmoticons() {
        return this.MAX_EMOTICONS;
    }

    private class Emoticon {
        private final String symbol;
        private final Replacer replacer;

        private Emoticon(Pattern pattern, String symbol) {
            this.symbol = symbol;
            this.replacer = new Replacer(pattern, "\\\\$1", this.getSymbol());
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toWiki(String text) {
            return this.replacer.replaceAll(text);
        }
    }

    private class Emoticons {
        private final List<Emoticon> emoticons;
        private final Pattern allEmoticonsPattern;

        public Emoticons(String[] symbols) {
            StringBuilder counterPattern = new StringBuilder();
            this.emoticons = new ArrayList<Emoticon>(symbols.length);
            for (String symbol : symbols) {
                String patternString = "(\\\\?" + RegExpUtil.convertToRegularExpression(symbol) + ')' + PhraseRendererComponent.VALID_END;
                this.emoticons.add(new Emoticon(Pattern.compile(patternString), symbol));
                counterPattern.append(patternString + "|");
            }
            counterPattern.setLength(counterPattern.length() - 1);
            this.allEmoticonsPattern = Pattern.compile(counterPattern.toString());
        }

        public String render(String wiki, RenderContext context) {
            Matcher matcher = this.allEmoticonsPattern.matcher(wiki);
            if (!matcher.find()) {
                return wiki;
            }
            int count = 1;
            int mark = 0;
            StringBuffer sb = new StringBuffer(wiki.length() * 2);
            do {
                sb.append(wiki, mark, matcher.start());
                EmoticonRendererComponent.this.appendSubstitution(sb, context, matcher);
                mark = matcher.end();
            } while (matcher.find() && ++count <= EmoticonRendererComponent.this.maxEmoticons());
            if (count > EmoticonRendererComponent.this.maxEmoticons()) {
                log.warn((Object)("Max number of emoticons (" + EmoticonRendererComponent.this.maxEmoticons() + ") reached for input hashed as " + DigestUtils.md2Hex((String)wiki) + ". MaxNumberOfEmoticonsToRenderReached"));
            }
            return sb.append(wiki, mark, wiki.length()).toString();
        }

        public String toWikiMarkup(String text) {
            for (Emoticon emoticon : this.emoticons) {
                text = emoticon.toWiki(text);
            }
            return text;
        }
    }
}

