/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.renderer.v2.components.UrlRendererComponent;
import com.atlassian.renderer.v2.components.link.LinkDecorator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;

public class LinkRendererComponent
implements RendererComponent {
    private LinkResolver linkResolver;
    public static final char START_LINK_CHAR = '[';
    private static final char ESCAPE_CHAR = '\\';
    private static final char END_LINK_CHAR = ']';
    private static final char NEW_LINE_CHAR = '\n';

    public LinkRendererComponent(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    @Override
    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    @Override
    public String render(String wiki, RenderContext context) {
        int end;
        if (wiki == null || wiki.length() < 3) {
            return wiki;
        }
        InsideLinkPatternCache cache = new InsideLinkPatternCache();
        int start = LinkRendererComponent.findLinkStart(wiki, 0, cache);
        while (start != -1 && (end = LinkRendererComponent.findLinkEnd(wiki, start)) != 0) {
            if (end < 0) {
                start = LinkRendererComponent.findLinkStart(wiki, -end, cache);
                continue;
            }
            return this.renderHeavy(wiki, context, start, end, cache);
        }
        return wiki;
    }

    private String renderHeavy(String wiki, RenderContext context, int start, int end, InsideLinkPatternCache cache) {
        int len = wiki.length();
        StringBuilder sb = new StringBuilder(len / 2 * 3 + 1);
        sb.append(wiki, 0, start);
        this.appendLink(sb, context, wiki.substring(start + 1, end));
        int mark = end + 1;
        start = LinkRendererComponent.findLinkStart(wiki, mark, cache);
        while (start != -1 && (end = LinkRendererComponent.findLinkEnd(wiki, start)) != 0) {
            if (end < 0) {
                start = LinkRendererComponent.findLinkStart(wiki, -end, cache);
                continue;
            }
            sb.append(wiki, mark, start);
            this.appendLink(sb, context, wiki.substring(start + 1, end));
            mark = end + 1;
            start = LinkRendererComponent.findLinkStart(wiki, mark, cache);
        }
        return sb.append(wiki, mark, len).toString();
    }

    private void appendLink(StringBuilder stringBuffer, RenderContext context, String linkText) {
        Link link = this.linkResolver.createLink(context, linkText);
        stringBuffer.append(context.getRenderedContentStore().addInline(new LinkDecorator(link)));
    }

    private static boolean isInsideAnyLinkPattern(String wiki, int index, InsideLinkPatternCache cache) {
        return cache.initializeIfNecessary(wiki).isIndexInsidePattern(index);
    }

    private static int findLinkStart(String wiki, int startIndex, InsideLinkPatternCache cache) {
        int len = wiki.length();
        int index = wiki.indexOf(91, startIndex);
        while (index != -1) {
            if (index <= 0 || wiki.charAt(index - 1) != '\\') {
                int nextIndex = index + 1;
                if (nextIndex == len) {
                    return -1;
                }
                char nextChar = wiki.charAt(nextIndex);
                if (nextChar != ']' && !Character.isWhitespace(nextChar) && !LinkRendererComponent.isInsideAnyLinkPattern(wiki, index, cache)) break;
            }
            index = wiki.indexOf(91, index + 1);
        }
        return index;
    }

    private static int findLinkEnd(String wiki, int startIndex) {
        int len = wiki.length();
        char prev = '\u0000';
        for (int index = startIndex + 1; index < len; ++index) {
            char c = wiki.charAt(index);
            switch (c) {
                case ']': {
                    if (prev == '\\') break;
                    return index;
                }
                case '[': {
                    if (prev == '\\') break;
                    return -index;
                }
                case '\n': {
                    return -(index + 1);
                }
            }
            prev = c;
        }
        return 0;
    }

    private class InsideLinkPatternCache {
        private NavigableMap<Integer, Integer> indices = null;

        InsideLinkPatternCache() {
        }

        InsideLinkPatternCache initializeIfNecessary(String wiki) {
            if (this.indices == null) {
                this.indices = new TreeMap<Integer, Integer>();
                Matcher matcher = UrlRendererComponent.PATTERN_WITH_EMBED.matcher(wiki);
                while (matcher.find()) {
                    this.indices.put(matcher.start(), matcher.end());
                }
            }
            return this;
        }

        boolean isIndexInsidePattern(int index) {
            if (this.indices.isEmpty()) {
                return false;
            }
            Map.Entry<Integer, Integer> entry = this.indices.floorEntry(index - 1);
            return entry != null && entry.getValue() > index;
        }
    }
}

