/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.basic.AbstractPanelMacro;
import com.atlassian.renderer.v2.macro.code.SimpleSourceCodeFormatterRepository;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatter;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatterRepository;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CodeMacro
extends AbstractPanelMacro {
    private static final String DEFAULT_LANG = "java";
    private SourceCodeFormatterRepository codeFormatterRepository;

    public CodeMacro(V2SubRenderer subRenderer, List formatters) {
        this.setCodeFormatterRepository(new SimpleSourceCodeFormatterRepository(formatters));
        this.setSubRenderer(subRenderer);
    }

    public void setCodeFormatterRepository(SourceCodeFormatterRepository codeFormatterRepository) {
        this.codeFormatterRepository = codeFormatterRepository;
    }

    public CodeMacro() {
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return false;
    }

    protected String getPanelCSSClass() {
        return "code panel";
    }

    protected String getPanelHeaderCSSClass() {
        return "codeHeader panelHeader";
    }

    protected String getPanelContentCSSClass() {
        return "codeContent panelContent";
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.allow(128L);
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String code;
        String language = this.getLanguage(parameters).toLowerCase();
        SourceCodeFormatter formatter = this.getFormatter(language);
        String preamble = "";
        if (formatter == null) {
            preamble = RenderUtils.blockError("Unable to find source-code formatter for language: " + language + ".", "Available languages are: " + TextUtils.join((String)", ", (Collection)this.codeFormatterRepository.getAvailableLanguages()));
            formatter = this.getFormatter(DEFAULT_LANG);
        }
        if ((code = body).startsWith("\n")) {
            code = code.substring(1);
        }
        if (code.endsWith("\n")) {
            code = code.substring(0, code.length());
        }
        return super.execute(parameters, preamble + "<pre class=\"code-" + language + "\">" + formatter.format(code, language) + "</pre>", renderContext);
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    private SourceCodeFormatter getFormatter(String language) {
        return this.codeFormatterRepository.getSourceCodeFormatter(language);
    }

    private String getLanguage(Map parameters) {
        String lang = (String)parameters.get("lang");
        if (!TextUtils.stringSet((String)lang)) {
            lang = (String)parameters.get("0");
        }
        if (!TextUtils.stringSet((String)lang)) {
            lang = DEFAULT_LANG;
        }
        return lang;
    }
}

