/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenRendererComponent
extends AbstractRegexRendererComponent {
    public static final String BLOCK_TOKEN_PATTERN_STR = "blktokxyzkdtnhgnsbdfblktok\\d+blktokxyzkdtnhgnsbdfblktok";
    static final Pattern BLOCK_TOKEN_PATTERN = Pattern.compile("blktokxyzkdtnhgnsbdfblktok\\d+blktokxyzkdtnhgnsbdfblktok");
    public static final String INLINE_TOKEN_PATTERN_STR = "inltokxyzkdtnhgnsbdfinltok\\d+inltokxyzkdtnhgnsbdfinltok";
    static final Pattern INLINE_TOKEN_PATTERN = Pattern.compile("inltokxyzkdtnhgnsbdfinltok\\d+inltokxyzkdtnhgnsbdfinltok");
    private final SubRenderer subRenderer;

    public TokenRendererComponent(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.resolveTokens() && renderMode.tokenizes();
    }

    public String render(String wiki, RenderContext context) {
        while (BLOCK_TOKEN_PATTERN.matcher(wiki).find() || INLINE_TOKEN_PATTERN.matcher(wiki).find()) {
            wiki = this.regexRender(wiki, context, BLOCK_TOKEN_PATTERN);
            wiki = this.regexRender(wiki, context, INLINE_TOKEN_PATTERN);
        }
        return wiki;
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        Object obj = context.getRenderedContentStore().get(matcher.group(0));
        if (obj instanceof Renderable) {
            Renderable renderable = (Renderable)obj;
            renderable.render(this.subRenderer, context, buffer);
        } else if (obj instanceof String) {
            buffer.append((String)obj);
        } else {
            throw new RuntimeException("Found object " + obj + " in token store?");
        }
    }
}

