/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.requesthandler;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.ratelimiting.requesthandler.RateLimitUiRequestHandler;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRateLimitUiRequestHandler
implements RateLimitUiRequestHandler {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_ORIGIN = "origin";
    public static final String HEADER_REFERER = "Referer";
    public static final String COOKIE_SESSION_ID = "JSESSIONID";
    public static final String COOKIE_CSRF_TOKEN = "atlassian.xsrf.token";
    private static final Logger logger = LoggerFactory.getLogger(DefaultRateLimitUiRequestHandler.class);
    private final List<String> headerNames;
    private final List<String> cookieNames;
    private final int quorumCount;

    @Override
    public boolean isUiRequest(HttpServletRequest request) {
        long uiHeaderCount = this.getUiHeaderCount(request);
        long uiCookieCount = this.getUiCookieCount(request);
        return this.haveQuorumOfUiCriteria(uiHeaderCount, uiCookieCount);
    }

    @Override
    public void logRequestInfo(HttpServletRequest request) {
        if (this.isTraceEnabled()) {
            long uiHeaderCount = this.getUiHeaderCount(request);
            Multimap uiHeaders = (Multimap)this.getHeaderNames().stream().collect(Multimaps.flatteningToMultimap(Function.identity(), h -> Collections.list(request.getHeaders(h)).stream(), () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.linkedHashKeys().arrayListValues()).build()));
            long uiCookieCount = this.getUiCookieCount(request);
            Multimap uiCookies = (Multimap)this.getUiCookies(request).collect(Multimaps.toMultimap(Cookie::getName, Cookie::getValue, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.linkedHashKeys().arrayListValues()).build()));
            boolean isUiRequest = this.haveQuorumOfUiCriteria(uiHeaderCount, uiCookieCount);
            logger.trace("All request headers: [{}], UI headers: [{}] (count: {}), UI cookies [{}] (count: {}), is UI request: [{}]", new Object[]{Collections.list(request.getHeaderNames()), uiHeaders, uiHeaderCount, uiCookies, uiCookieCount, isUiRequest});
            String authHeader = Objects.nonNull(request.getHeader(HEADER_AUTHORIZATION)) ? request.getHeader(HEADER_AUTHORIZATION) : "no header found";
            logger.trace("Authorization: {}", (Object)authHeader);
        }
    }

    private long getUiHeaderCount(HttpServletRequest request) {
        return this.getHeaderNames().stream().map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).count();
    }

    private long getUiCookieCount(HttpServletRequest request) {
        return this.getUiCookies(request).count();
    }

    private Stream<Cookie> getUiCookies(HttpServletRequest request) {
        Stream<Cookie> stream = Objects.nonNull(request.getCookies()) ? Stream.of(request.getCookies()) : Stream.empty();
        return stream.filter(cookie -> this.getCookieNames().stream().anyMatch(cookieName -> cookieName.equalsIgnoreCase(cookie.getName())));
    }

    private boolean haveQuorumOfUiCriteria(long uiHeaderCount, long uiCookieCount) {
        return uiHeaderCount + uiCookieCount >= (long)this.quorumCount;
    }

    @VisibleForTesting
    public boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    public List<String> getHeaderNames() {
        return this.headerNames;
    }

    public List<String> getCookieNames() {
        return this.cookieNames;
    }

    public int getQuorumCount() {
        return this.quorumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRateLimitUiRequestHandler)) {
            return false;
        }
        DefaultRateLimitUiRequestHandler other = (DefaultRateLimitUiRequestHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$headerNames = this.getHeaderNames();
        List<String> other$headerNames = other.getHeaderNames();
        if (this$headerNames == null ? other$headerNames != null : !((Object)this$headerNames).equals(other$headerNames)) {
            return false;
        }
        List<String> this$cookieNames = this.getCookieNames();
        List<String> other$cookieNames = other.getCookieNames();
        if (this$cookieNames == null ? other$cookieNames != null : !((Object)this$cookieNames).equals(other$cookieNames)) {
            return false;
        }
        return this.getQuorumCount() == other.getQuorumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultRateLimitUiRequestHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $headerNames = this.getHeaderNames();
        result = result * 59 + ($headerNames == null ? 43 : ((Object)$headerNames).hashCode());
        List<String> $cookieNames = this.getCookieNames();
        result = result * 59 + ($cookieNames == null ? 43 : ((Object)$cookieNames).hashCode());
        result = result * 59 + this.getQuorumCount();
        return result;
    }

    public String toString() {
        return "DefaultRateLimitUiRequestHandler(headerNames=" + this.getHeaderNames() + ", cookieNames=" + this.getCookieNames() + ", quorumCount=" + this.getQuorumCount() + ")";
    }

    public DefaultRateLimitUiRequestHandler(List<String> headerNames, List<String> cookieNames, int quorumCount) {
        this.headerNames = headerNames;
        this.cookieNames = cookieNames;
        this.quorumCount = quorumCount;
    }
}

