/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.impl;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.search.v2.BooleanQueryBuilder;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ActiveUserSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ArchivedSpacesSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.BooleanSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentStatusFilter;
import com.atlassian.confluence.search.v2.searchfilter.ExcludedContentTypeSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchFilterFactory {
    private final SpaceManager spaceManager;
    private final CollaborativeEditingHelper collaborativeEditingHelper;

    @Autowired
    public SearchFilterFactory(@ComponentImport SpaceManager spaceManager, @ComponentImport CollaborativeEditingHelper collaborativeEditingHelper) {
        this.spaceManager = spaceManager;
        this.collaborativeEditingHelper = collaborativeEditingHelper;
    }

    public SearchFilter makeFilter(boolean includeArchivedSpaces, List<ContentStatus> contentStatuses) {
        Objects.requireNonNull(contentStatuses);
        BooleanQueryBuilder builder = BooleanSearchFilter.builder().addMust((Object)this.createCacheableFilter(contentStatuses)).addMust((Object)SiteSearchPermissionsSearchFilter.getInstance());
        if (!includeArchivedSpaces) {
            builder.addMust((Object)new ArchivedSpacesSearchFilter(false, this.spaceManager));
        }
        return (SearchFilter)builder.build();
    }

    private SearchFilter createCacheableFilter(List<ContentStatus> contentStatuses) {
        BooleanQueryBuilder builder = BooleanSearchFilter.builder().addMust((Object)ExcludedContentTypeSearchFilter.getInstance()).addMust((Object)ActiveUserSearchFilter.getInstance());
        if (contentStatuses.isEmpty() || this.collaborativeEditingHelper.getEditMode("").equals("legacy")) {
            builder.addMust((Object)ContentStatusFilter.getDefaultStatusInstance());
        } else {
            builder.addMust((Object)new ContentStatusFilter(contentStatuses));
        }
        return (SearchFilter)builder.build();
    }
}

