/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.plugins.cql.spi.fields.AbstractUserFieldHandler;
import com.atlassian.confluence.plugins.cql.spi.sort.BaseUserSort;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.google.common.collect.Sets;

public class UserKeyFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private final AbstractUserFieldHandler delegateFieldHandler;

    public UserKeyFieldHandler(AbstractUserFieldHandler delegateFieldHandler) {
        this("userkey", delegateFieldHandler);
    }

    public UserKeyFieldHandler(String fieldName, AbstractUserFieldHandler delegateFieldHandler) {
        super(fieldName, true);
        this.delegateFieldHandler = delegateFieldHandler;
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new SetExpressionData.Operator[]{SetExpressionData.Operator.IN, SetExpressionData.Operator.NOT_IN}));
        SearchQuery query = V2FieldHandlerHelper.joinSingleValueQueries(values, this.createSearchQuery());
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)((SearchQuery)this.createSearchQuery().apply((Object)value)), (ExpressionData)expressionData);
    }

    private Function<String, SearchQuery> createSearchQuery() {
        return new Function<String, SearchQuery>(){

            public SearchQuery apply(String value) {
                UserKey userKey = new UserKey(value);
                return UserKeyFieldHandler.this.delegateFieldHandler.createUserQuery(userKey, null);
            }
        };
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return this.delegateFieldHandler.buildOrder(direction, BaseUserSort.UserSortType.USERKEY);
    }
}

