/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.sort.FavouriteSort;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.google.common.collect.Sets;

public class FavouriteFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private static final String FIELD_NAME = "favourite";
    private final UserAccessor userAccessor;

    public FavouriteFieldHandler(@ComponentImport UserAccessor userAccessor) {
        this(FIELD_NAME, userAccessor);
    }

    public FavouriteFieldHandler(String fieldName, UserAccessor userAccessor) {
        super(fieldName, true);
        this.userAccessor = userAccessor;
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new SetExpressionData.Operator[]{SetExpressionData.Operator.IN, SetExpressionData.Operator.NOT_IN}));
        SearchQuery query = V2FieldHandlerHelper.joinSingleValueQueries(values, this::buildLabelQuery);
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)this.buildLabelQuery(value), (ExpressionData)expressionData);
    }

    private LabelQuery buildLabelQuery(String value) {
        return new LabelQuery(this.buildFavouriteLabel(value));
    }

    private Label buildFavouriteLabel(String username) {
        ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user != null && !user.equals(authenticatedUser)) {
            throw new PermissionException("Users can just get their own favourites");
        }
        return new Label(FIELD_NAME, Namespace.PERSONAL, user);
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return new V2SearchSortWrapper((SearchSort)new FavouriteSort(V2SearchSortWrapper.convertOrder((OrderDirection)direction)));
    }
}

