/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.plugins.cql.fields.CQLFieldDefaults;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.v2search.query.NoneQuery;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.exceptions.GenericQueryException;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.TextFieldHandler;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.TextExpressionData;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;

public class SpaceTitleFieldHandler
extends BaseFieldHandler
implements TextFieldHandler<V2SearchQueryWrapper> {
    private final PredefinedSearchBuilder predefinedSearchBuilder;
    private final SearchManager searchManager;
    private static final ImmutableSet<String> SPACE_KEY_FIELD = ImmutableSet.of((Object)"spacekey");

    protected SpaceTitleFieldHandler(@ComponentImport PredefinedSearchBuilder predefinedSearchBuilder, @ComponentImport SearchManager searchManager) {
        super("space.title");
        this.predefinedSearchBuilder = predefinedSearchBuilder;
        this.searchManager = searchManager;
    }

    private Set<String> findSpaceKeysForSpaceName(String value) {
        SearchQueryParameters params = new SearchQueryParameters(value);
        params.setContentTypes((Set)Sets.newHashSet((Object[])new ContentTypeEnum[]{ContentTypeEnum.SPACE_DESCRIPTION, ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION}));
        params.setSort((SearchSort)TitleSort.ASCENDING);
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, 0, CQLFieldDefaults.MAX_INTERIM_FIELD_RESULTS);
        try {
            SearchResults searchResults = this.searchManager.search(search, SPACE_KEY_FIELD);
            return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)searchResults, (Function)new Function<SearchResult, String>(){

                public String apply(SearchResult input) {
                    return input.getSpaceKey();
                }
            }));
        }
        catch (InvalidSearchException ex) {
            throw new GenericQueryException("Could not perform space search for value : " + value, (Throwable)ex);
        }
    }

    public V2SearchQueryWrapper build(TextExpressionData expressionData, String value) {
        this.validateSupportedOp(expressionData.getOperator(), Sets.newHashSet((Object[])new TextExpressionData.Operator[]{TextExpressionData.Operator.CONTAINS, TextExpressionData.Operator.NOT_CONTAINS}));
        Set<String> keys = this.findSpaceKeysForSpaceName(value);
        if (Iterables.isEmpty(keys)) {
            return new V2SearchQueryWrapper((SearchQuery)new NoneQuery());
        }
        InSpaceQuery query = new InSpaceQuery((Set)Sets.newHashSet(keys));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }
}

