/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.plugins;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.functions.QueryFunction;
import com.atlassian.querylang.lib.plugins.BaseAQLModuleDescriptor;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class AQLFunctionModuleDescriptor
extends BaseAQLModuleDescriptor<QueryFunction> {
    private Optional<String> functionName;

    public AQLFunctionModuleDescriptor(@ComponentImport ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.functionName = Optional.ofNullable(element.attributeValue("functionName"));
    }

    @Override
    public void enabled() {
        super.enabled();
        this.overrideFunctionName();
    }

    private void overrideFunctionName() {
        QueryFunction function = (QueryFunction)this.getModule();
        try {
            if (this.functionName.isPresent()) {
                Field field = QueryFunction.class.getDeclaredField("name");
                field.setAccessible(true);
                field.set(function, this.functionName.get());
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

