/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.parserfactory;

import com.atlassian.querylang.antlrgen.AqlLexer;
import com.atlassian.querylang.antlrgen.AqlParser;
import com.atlassian.querylang.antlrgen.AqlSimpleParser;
import com.atlassian.querylang.antlrgen.AqlVisitor;
import com.atlassian.querylang.lib.fields.FieldRegistry;
import com.atlassian.querylang.lib.functions.FunctionRegistry;
import com.atlassian.querylang.lib.parserfactory.AqlParserFactory;
import com.atlassian.querylang.lib.parserfactory.ParserConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class DefaultParserFactory
implements AqlParserFactory {
    private static final int BUFFER_SIZE = 4096;

    @Override
    public AqlParser createParser(String toParse, FieldRegistry fieldRegistry, FunctionRegistry functionRegistry, ParserConfig config) throws IOException {
        AqlParser parser = this.initCommon(new AqlParser((TokenStream)this.createTokenStream(toParse)), config);
        parser.setFieldRegistry(fieldRegistry);
        parser.setFunctionRegistry(functionRegistry);
        AqlVisitor visitor = config.getErrorVisitor(fieldRegistry, functionRegistry);
        if (visitor != null) {
            visitor.visit((ParseTree)parser.aqlStatement());
            parser.reset();
        }
        return parser;
    }

    @Override
    public AqlSimpleParser createSimpleParser(String toParse, ParserConfig config) throws IOException {
        return this.initCommon(new AqlSimpleParser((TokenStream)this.createTokenStream(toParse)), config);
    }

    private CommonTokenStream createTokenStream(String toParse) throws IOException {
        ANTLRInputStream stream = new ANTLRInputStream((Reader)new StringReader(toParse), 4096);
        return new CommonTokenStream((TokenSource)new AqlLexer((CharStream)stream));
    }

    private <T extends Parser> T initCommon(T parser, ParserConfig config) {
        if (config != null) {
            parser.setErrorHandler(config.getErrorStrategy());
            parser.setBuildParseTree(config.isBuildParseTrees());
        }
        return parser;
    }
}

